/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.monitor;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.opensearch.monitor.MemoryUsage;
import org.opensearch.sql.opensearch.monitor.OpenSearchMemoryHealthy;

public class GCedMemoryUsage
implements MemoryUsage {
    private static final Logger LOG = LogManager.getLogger();
    private static final List<String> OLD_GEN_GC_ACTION_KEYWORDS = List.of("major", "concurrent", "old", "full", "marksweep");
    private static boolean initialized = false;
    private final AtomicLong usage = new AtomicLong(-1L);

    private GCedMemoryUsage() {
        this.registerGCListener();
    }

    public static MemoryUsage getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public long usage() {
        return this.usage.get();
    }

    @Override
    public void setUsage(long value) {
        this.usage.set(value);
    }

    public static boolean initialized() {
        return initialized;
    }

    private void registerGCListener() {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        if (gcBeans.stream().filter(b -> b instanceof NotificationEmitter).noneMatch(b -> this.containConcurrentGcBean(b.getName()))) {
            LOG.info("No Concurrent Garbage Collector MXBean, fallback to RuntimeMemoryUsage");
            throw new OpenSearchMemoryHealthy.MemoryUsageException();
        }
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            if (!(gcBean instanceof NotificationEmitter) || !this.isOldGenGc(gcBean.getName())) continue;
            LOG.info("{} listener registered for memory usage monitor.", (Object)gcBean.getName());
            initialized = true;
            NotificationEmitter emitter = (NotificationEmitter)((Object)gcBean);
            emitter.addNotificationListener(new OldGenGCListener(), notification -> {
                if (!notification.getType().equals("com.sun.management.gc.notification")) {
                    return false;
                }
                CompositeData cd2 = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from(cd2);
                return this.isOldGenGc(info.getGcAction());
            }, null);
        }
    }

    private boolean containConcurrentGcBean(String beanName) {
        return beanName.toLowerCase(Locale.ROOT).contains("concurrent");
    }

    private boolean isOldGenGc(String gcKeyword) {
        String keyword = gcKeyword.toLowerCase(Locale.ROOT);
        return OLD_GEN_GC_ACTION_KEYWORDS.stream().anyMatch(keyword::contains);
    }

    private static class Holder {
        static final MemoryUsage INSTANCE = new GCedMemoryUsage();

        private Holder() {
        }
    }

    private static class OldGenGCListener
    implements NotificationListener {
        private OldGenGCListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            CompositeData cd2 = (CompositeData)notification.getUserData();
            GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from(cd2);
            Map<String, java.lang.management.MemoryUsage> memoryUsageAfterGc = info.getGcInfo().getMemoryUsageAfterGc();
            long totalStackUsed = memoryUsageAfterGc.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("Metaspace") && !((String)entry.getKey()).equals("Compressed Class Space") && !((String)entry.getKey()).startsWith("CodeHeap")).mapToLong(entry -> ((java.lang.management.MemoryUsage)entry.getValue()).getUsed()).sum();
            GCedMemoryUsage.getInstance().setUsage(totalStackUsed);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Old Gen GC detected, memory usage after GC is {} bytes.", (Object)totalStackUsed);
            }
        }
    }
}

