/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.elasticmapreduce.model.EbsConfiguration;
import java.util.List;

@SdkInternalApi
public class EbsConfigurationMarshaller {
    private static final MarshallingInfo<List> EBSBLOCKDEVICECONFIGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsBlockDeviceConfigs").build();
    private static final MarshallingInfo<Boolean> EBSOPTIMIZED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsOptimized").build();
    private static final EbsConfigurationMarshaller instance = new EbsConfigurationMarshaller();

    public static EbsConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(EbsConfiguration ebsConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (ebsConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(ebsConfiguration.getEbsBlockDeviceConfigs(), EBSBLOCKDEVICECONFIGS_BINDING);
            protocolMarshaller.marshall(ebsConfiguration.getEbsOptimized(), EBSOPTIMIZED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

