/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.context.Context;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class DaemonThreadFactory
implements ThreadFactory {
    private final String namePrefix;
    private final AtomicInteger counter = new AtomicInteger();
    private final ThreadFactory delegate = Executors.defaultThreadFactory();
    private final boolean propagateContextForTesting;

    public DaemonThreadFactory(String namePrefix) {
        this(namePrefix, false);
    }

    public DaemonThreadFactory(String namePrefix, boolean propagateContextForTesting) {
        this.namePrefix = namePrefix;
        this.propagateContextForTesting = propagateContextForTesting;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t = this.delegate.newThread(this.propagateContextForTesting ? Context.current().wrap(runnable) : runnable);
        try {
            t.setDaemon(true);
            t.setName(this.namePrefix + "-" + this.counter.incrementAndGet());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return t;
    }
}

