/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format;

import java.sql.SQLException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JdbcDateJavaType;
import org.hibernate.type.descriptor.java.JdbcTimeJavaType;
import org.hibernate.type.descriptor.java.JdbcTimestampJavaType;
import org.hibernate.type.descriptor.java.OffsetDateTimeJavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.format.JsonDocumentReader;
import org.hibernate.type.format.JsonValueJDBCTypeAdapter;

public class OsonValueJDBCTypeAdapter
implements JsonValueJDBCTypeAdapter {
    @Override
    public Object fromValue(JavaType<?> jdbcJavaType, JdbcType jdbcType, JsonDocumentReader source, WrapperOptions options) throws SQLException {
        Object valueToBeWrapped = null;
        switch (jdbcType.getDefaultSqlTypeCode()) {
            case -4: 
            case -3: 
            case -2: 
            case 4003: {
                valueToBeWrapped = source.getValue(PrimitiveByteArrayJavaType.INSTANCE, options);
                break;
            }
            case 91: {
                valueToBeWrapped = source.getValue(JdbcDateJavaType.INSTANCE, options);
                break;
            }
            case 92: 
            case 2013: 
            case 3007: {
                valueToBeWrapped = source.getValue(JdbcTimeJavaType.INSTANCE, options);
                break;
            }
            case 93: {
                valueToBeWrapped = source.getValue(JdbcTimestampJavaType.INSTANCE, options);
                break;
            }
            case 2014: 
            case 3003: {
                valueToBeWrapped = source.getValue(OffsetDateTimeJavaType.INSTANCE, options);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                if (jdbcJavaType.getJavaTypeClass() == Boolean.class) {
                    valueToBeWrapped = source.getIntegerValue();
                    break;
                }
                if (jdbcJavaType instanceof EnumJavaType) {
                    valueToBeWrapped = source.getIntegerValue();
                    break;
                }
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                if (jdbcJavaType.getJavaTypeClass() != Boolean.class) break;
                valueToBeWrapped = source.getBooleanValue();
            }
        }
        if (valueToBeWrapped == null) {
            valueToBeWrapped = source.getValue(jdbcJavaType, options);
        }
        return jdbcJavaType.wrap(valueToBeWrapped, options);
    }

    @Override
    public Object fromNumericValue(JavaType<?> jdbcJavaType, JdbcType jdbcType, JsonDocumentReader source, WrapperOptions options) throws SQLException {
        return this.fromValue(jdbcJavaType, jdbcType, source, options);
    }
}

