/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.internal.CustomMutabilityConvertedBasicTypeImpl;
import org.hibernate.type.internal.ImmutableNamedBasicTypeImpl;
import org.hibernate.type.internal.NamedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserType;

public class BasicTypeRegistry
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(BasicTypeRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private final Map<JdbcType, Map<JavaType<?>, BasicType<?>>> registryValues = new ConcurrentHashMap();
    private boolean primed;
    private final Map<String, BasicType<?>> typesByName = new ConcurrentHashMap();
    private final Map<String, BasicTypeReference<?>> typeReferencesByName = new ConcurrentHashMap();

    public BasicTypeRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    public <J> BasicType<J> getRegisteredType(String key) {
        BasicType<?> basicType = this.typesByName.get(key);
        if (basicType == null) {
            basicType = this.resolveTypeReference(key);
        }
        return basicType;
    }

    private BasicType<?> resolveTypeReference(String name) {
        BasicType<?> basicType;
        BasicTypeReference<?> typeReference = this.typeReferencesByName.get(name);
        if (typeReference == null) {
            return null;
        }
        if (!name.equals(typeReference.getName()) && (basicType = this.typesByName.get(typeReference.getName())) != null) {
            return basicType;
        }
        return this.createBasicType(name, typeReference);
    }

    private BasicType<?> createBasicType(String name, BasicTypeReference<?> typeReference) {
        JavaType<Object> javaType = this.typeConfiguration.getJavaTypeRegistry().getDescriptor(typeReference.getJavaType());
        JdbcType jdbcType = this.typeConfiguration.getJdbcTypeRegistry().getDescriptor(typeReference.getSqlTypeCode());
        BasicType<?> createdType = BasicTypeRegistry.createBasicType(typeReference, javaType, jdbcType);
        this.primeRegistryEntry(createdType);
        this.typesByName.put(typeReference.getName(), createdType);
        this.typesByName.put(name, createdType);
        return createdType;
    }

    private static BasicType<?> createBasicType(BasicTypeReference<?> typeReference, JavaType<Object> javaType, JdbcType jdbcType) {
        String name = typeReference.getName();
        if (typeReference.getConverter() == null) {
            return typeReference.isForceImmutable() ? new ImmutableNamedBasicTypeImpl<Object>(javaType, jdbcType, name) : new NamedBasicTypeImpl<Object>(javaType, jdbcType, name);
        }
        BasicValueConverter<?, ?> converter = typeReference.getConverter();
        assert (javaType == converter.getDomainJavaType());
        return typeReference.isForceImmutable() ? new CustomMutabilityConvertedBasicTypeImpl(name, jdbcType, converter, ImmutableMutabilityPlan.instance()) : new ConvertedBasicTypeImpl(name, jdbcType, converter);
    }

    public <J> BasicType<J> getRegisteredType(java.lang.reflect.Type javaType) {
        return this.getRegisteredType(javaType.getTypeName());
    }

    public <J> BasicType<J> getRegisteredType(Class<J> javaType) {
        return this.getRegisteredType(javaType.getTypeName());
    }

    public BasicType<?> getRegisteredArrayType(java.lang.reflect.Type javaElementType) {
        return this.getRegisteredType(javaElementType.getTypeName() + "[]");
    }

    public <J> BasicType<J> resolve(BasicTypeReference<J> basicTypeReference) {
        return this.getRegisteredType(basicTypeReference.getName());
    }

    public <J> BasicType<J> resolve(Class<J> javaType, int sqlTypeCode) {
        return this.resolve((java.lang.reflect.Type)javaType, sqlTypeCode);
    }

    public <J> BasicType<J> resolve(java.lang.reflect.Type javaType, int sqlTypeCode) {
        return this.resolve(this.typeConfiguration.getJavaTypeRegistry().getDescriptor(javaType), sqlTypeCode);
    }

    public <J> BasicType<J> resolve(JavaType<J> javaType, int sqlTypeCode) {
        return this.resolve(javaType, this.typeConfiguration.getJdbcTypeRegistry().getDescriptor(sqlTypeCode));
    }

    public <J> BasicType<J> resolve(JavaType<J> javaType, JdbcType jdbcType) {
        return this.resolve(javaType, jdbcType, () -> this.resolvedType(javaType, jdbcType));
    }

    private <J> BasicType<J> resolvedType(JavaType<J> javaType, JdbcType jdbcType) {
        if (javaType instanceof BasicPluralJavaType) {
            BasicPluralJavaType pluralJavaType = (BasicPluralJavaType)((Object)javaType);
            if (jdbcType instanceof ArrayJdbcType) {
                ArrayJdbcType arrayType = (ArrayJdbcType)jdbcType;
                return this.resolvedType(arrayType, pluralJavaType);
            }
        }
        return new BasicTypeImpl<J>(javaType, jdbcType);
    }

    private <E> BasicType<?> resolvedType(ArrayJdbcType arrayType, BasicPluralJavaType<E> castPluralJavaType) {
        Class<E> elementJavaTypeClass;
        BasicType<E> elementType = this.resolve(castPluralJavaType.getElementJavaType(), arrayType.getElementJdbcType());
        BasicType<?> resolvedType = castPluralJavaType.resolveType(this.typeConfiguration, this.typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect(), elementType, null, this.typeConfiguration.getCurrentBaseSqlTypeIndicators());
        if (resolvedType instanceof BasicPluralType) {
            this.register(resolvedType);
        } else if (resolvedType == null && (elementJavaTypeClass = elementType.getJavaTypeDescriptor().getJavaTypeClass()) != null && elementJavaTypeClass.isArray() && elementJavaTypeClass != byte[].class) {
            throw new MappingException("Nested arrays (with the exception of byte[][]) are not supported");
        }
        return resolvedType;
    }

    public <J> BasicType<J> resolve(JavaType<J> javaType, JdbcType jdbcType, String baseTypeName) {
        return this.resolve(javaType, jdbcType, () -> new NamedBasicTypeImpl(javaType, jdbcType, baseTypeName));
    }

    public <J> BasicType<J> resolve(JavaType<J> javaType, JdbcType jdbcType, Supplier<BasicType<J>> creator) {
        BasicType<?> registeredBasicType = this.registryForJdbcType(jdbcType).get(javaType);
        return registeredBasicType != null ? registeredBasicType : this.createIfUnregistered(javaType, jdbcType, creator);
    }

    private <J> BasicType<J> createIfUnregistered(JavaType<J> javaType, JdbcType jdbcType, Supplier<BasicType<J>> creator) {
        BasicType<J> registeredType = this.getRegisteredType(javaType.getJavaType());
        if (BasicTypeRegistry.registeredTypeMatches(javaType, jdbcType, registeredType)) {
            return registeredType;
        }
        BasicType<J> createdType = creator.get();
        this.register(javaType, jdbcType, createdType);
        return createdType;
    }

    private static <J> boolean registeredTypeMatches(JavaType<J> javaType, JdbcType jdbcType, BasicType<J> registeredType) {
        return registeredType != null && registeredType.getJdbcType() == jdbcType && registeredType.getMappedJavaType() == javaType;
    }

    private <J> void register(JavaType<J> javaType, JdbcType jdbcType, BasicType<J> createdType) {
        if (createdType != null) {
            this.registryForJdbcType(jdbcType).put(javaType, createdType);
            try {
                this.typeConfiguration.getMetadataBuildingContext().getBootstrapContext().registerAdHocBasicType(createdType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void register(BasicType<?> type) {
        this.register(type, type.getRegistrationKeys());
    }

    public void register(BasicType<?> type, String key) {
        this.register(type, new String[]{key});
    }

    public void register(BasicType<?> type, String ... keys) {
        if (!this.isPrimed()) {
            throw new IllegalStateException("BasicTypeRegistry not yet primed.  Calls to `#register` not valid until after primed");
        }
        if (type == null) {
            throw new HibernateException("Type to register cannot be null");
        }
        this.applyOrOverwriteEntry(type);
        if (CollectionHelper.isEmpty(keys)) {
            LOG.typeDefinedNoRegistrationKeys(type);
        } else {
            this.applyRegistrationKeys(type, keys);
        }
    }

    private void applyOrOverwriteEntry(BasicType<?> type) {
        JdbcType jdbcType = type.getJdbcType();
        BasicType<?> existing = this.registryForJdbcType(jdbcType).put(type.getMappedJavaType(), type);
        if (existing != null) {
            LOG.tracef("BasicTypeRegistry registration overwritten (%s + %s); previous =`%s`", jdbcType.getFriendlyName(), type.getJavaTypeDescriptor(), existing);
        }
    }

    public <T> CustomType<T> register(UserType<T> type, String ... keys) {
        CustomType<T> customType = new CustomType<T>(type, keys, this.typeConfiguration);
        this.register(customType);
        return customType;
    }

    public void unregister(String ... keys) {
        for (String key : keys) {
            this.typesByName.remove(key);
        }
    }

    @Internal
    public void addTypeReferenceRegistrationKey(String typeReferenceKey, String ... additionalTypeReferenceKeys) {
        BasicTypeReference<?> basicTypeReference = this.typeReferencesByName.get(typeReferenceKey);
        if (basicTypeReference == null) {
            throw new IllegalArgumentException("Couldn't find type reference with name: " + typeReferenceKey);
        }
        for (String additionalTypeReferenceKey : additionalTypeReferenceKeys) {
            this.typeReferencesByName.put(additionalTypeReferenceKey, basicTypeReference);
        }
    }

    public boolean isPrimed() {
        return this.primed;
    }

    public void primed() {
        this.primed = true;
    }

    public void addPrimeEntry(BasicType<?> type, String legacyTypeClassName, String[] registrationKeys) {
        if (this.primed) {
            throw new IllegalStateException("BasicTypeRegistry already primed");
        }
        if (type == null) {
            throw new HibernateException("Type to register cannot be null");
        }
        this.primeRegistryEntry(type);
        if (StringHelper.isNotEmpty(legacyTypeClassName)) {
            this.typesByName.put(legacyTypeClassName, type);
        }
        if (registrationKeys == null || registrationKeys.length == 0) {
            LOG.typeDefinedNoRegistrationKeys(type);
        } else {
            this.applyRegistrationKeys(type, registrationKeys);
        }
    }

    public void addPrimeEntry(BasicTypeReference<?> type, String legacyTypeClassName, String[] registrationKeys) {
        if (this.primed) {
            throw new IllegalStateException("BasicTypeRegistry already primed");
        }
        if (type == null) {
            throw new HibernateException("Type to register cannot be null");
        }
        if (StringHelper.isNotEmpty(legacyTypeClassName)) {
            this.typeReferencesByName.put(legacyTypeClassName, type);
        }
        if (registrationKeys == null || registrationKeys.length == 0) {
            LOG.typeDefinedNoRegistrationKeys(type);
        } else {
            this.applyRegistrationKeys(type, registrationKeys);
        }
    }

    private void primeRegistryEntry(BasicType<?> type) {
        JdbcType jdbcType = type.getJdbcType();
        BasicType<?> existing = this.registryForJdbcType(jdbcType).get(type.getMappedJavaType());
        if (existing != null) {
            LOG.tracef("Skipping registration of BasicType (%s + %s); still priming.  existing = %s", jdbcType.getFriendlyName(), type.getJavaTypeDescriptor(), existing);
        } else {
            this.registryForJdbcType(jdbcType).put(type.getMappedJavaType(), type);
        }
    }

    private Map<JavaType<?>, BasicType<?>> registryForJdbcType(JdbcType jdbcType) {
        return this.registryValues.computeIfAbsent(jdbcType, key -> new ConcurrentHashMap());
    }

    private void applyRegistrationKeys(BasicType<?> type, String[] keys) {
        for (String key : keys) {
            if (key == null) continue;
            key = key.intern();
            Type type2 = this.typesByName.put(key, type);
        }
    }

    private void applyRegistrationKeys(BasicTypeReference<?> type, String[] keys) {
        for (String key : keys) {
            if (key == null) continue;
            key = key.intern();
            BasicTypeReference<?> basicTypeReference = this.typeReferencesByName.put(key, type);
        }
    }
}

