/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.ipatuura_user_spi;

import java.io.IOException;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.http.simple.SimpleHttpResponse;
import org.keycloak.ipatuura_user_spi.Ipatuura;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;

public class IpatuuraUserModelDelegate
extends UserModelDelegate {
    private static final Logger logger = Logger.getLogger(IpatuuraUserModelDelegate.class);
    private ComponentModel model;
    private final Ipatuura ipatuura;

    public IpatuuraUserModelDelegate(Ipatuura ipatuura, UserModel delegate, ComponentModel model) {
        super(delegate);
        this.model = model;
        this.ipatuura = ipatuura;
    }

    public void setAttribute(String attr, List<String> values) {
        SimpleHttpResponse resp = this.ipatuura.updateUser(this.ipatuura, this.getUsername(), attr, values);
        try {
            if (resp.getStatus() != 200 && resp.getStatus() != 204) {
                logger.warn((Object)"Unexpected PUT status code returned");
                resp.close();
                return;
            }
            resp.close();
        }
        catch (IOException e) {
            logger.errorv("Error: {0}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        super.setAttribute(attr, values);
    }

    public void setSingleAttribute(String name, String value) {
        super.setSingleAttribute(name, value);
    }

    public void setUsername(String username) {
        super.setUsername(username);
    }

    public void setLastName(String lastName) {
        super.setLastName(lastName);
    }

    public void setFirstName(String first) {
        super.setFirstName(first);
    }

    public void setEmail(String email) {
        super.setFirstName(email);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }
}

