/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public class EntryThisMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 14;
    private int thisSym;
    private int bytesRemaining;

    public EntryThisMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.thisSym = reader.parseUnsignedByteVal();
        this.bytesRemaining = reader.getLimit() - reader.getIndex();
    }

    @Override
    public int getPdbId() {
        return 14;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s", this.getSymbolTypeName()));
        builder.append(String.format(", 'this' symbol: %02x", this.thisSym));
        builder.append(String.format("; byte length of remaining data = %d", this.bytesRemaining));
    }

    @Override
    protected String getSymbolTypeName() {
        return "ENTRYTHIS";
    }
}

