/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CommentType;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.FunctionRepeatableCommentFieldLocation;
import ghidra.program.util.PlateFieldLocation;
import ghidra.program.util.ProgramLocation;

public class CommentTypeUtils {
    public static CommentType getCommentType(CodeUnit cu, ProgramLocation loc, CommentType defaultCommentType) {
        if (loc instanceof CommentFieldLocation) {
            CommentFieldLocation cfLoc = (CommentFieldLocation)loc;
            CommentType type = cfLoc.getCommentType();
            if (type != null) {
                return type;
            }
        } else {
            if (loc instanceof PlateFieldLocation) {
                return CommentType.PLATE;
            }
            if (loc instanceof FunctionRepeatableCommentFieldLocation) {
                return CommentType.REPEATABLE;
            }
            if (cu != null) {
                if (cu.getComment(CommentType.PRE) != null) {
                    return CommentType.PRE;
                }
                if (cu.getComment(CommentType.POST) != null) {
                    return CommentType.POST;
                }
                if (cu.getComment(CommentType.EOL) != null) {
                    return CommentType.EOL;
                }
                if (cu.getComment(CommentType.PLATE) != null) {
                    return CommentType.PLATE;
                }
                if (cu.getComment(CommentType.REPEATABLE) != null) {
                    return CommentType.REPEATABLE;
                }
            }
        }
        return defaultCommentType;
    }

    public static boolean isCommentAllowed(CodeUnit cu, ProgramLocation loc) {
        return cu != null;
    }
}

