/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.BinaryCodedField;
import db.BinaryField;
import db.DBBuffer;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.FileBytesAdapter;
import ghidra.util.MonitoredInputStream;
import ghidra.util.exception.IOCancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class FileBytesAdapterV0
extends FileBytesAdapter {
    static final String TABLE_NAME = "File Bytes";
    static final int VERSION = 0;
    public static final int V0_FILENAME_COL = 0;
    public static final int V0_OFFSET_COL = 1;
    public static final int V0_SIZE_COL = 2;
    public static final int V0_BUF_IDS_COL = 3;
    public static final int V0_LAYERED_BUF_IDS_COL = 4;
    static final Schema SCHEMA = new Schema(0, "Key", new Field[]{StringField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, BinaryField.INSTANCE, BinaryField.INSTANCE}, new String[]{"Filename", "Offset", "Size", "Chain Buffer IDs", "Layered Chain Buffer IDs"});
    private Table table;
    private List<FileBytes> fileBytesList = new ArrayList<FileBytes>();

    FileBytesAdapterV0(DBHandle handle, boolean create) throws VersionException, IOException {
        super(handle);
        if (create) {
            this.table = handle.createTable(TABLE_NAME, SCHEMA);
        } else {
            this.table = handle.getTable(TABLE_NAME);
            if (this.table == null) {
                throw new VersionException(true);
            }
            if (this.table.getSchema().getVersion() != 0) {
                throw new VersionException(2, false);
            }
        }
        for (DBRecord record : this.table) {
            this.fileBytesList.add(new FileBytes(this, record));
        }
    }

    @Override
    FileBytes createFileBytes(String filename, long offset, long size, InputStream is, TaskMonitor monitor) throws IOException {
        DBBuffer[] buffers = this.createBuffers(size, is, monitor);
        DBBuffer[] layeredBuffers = this.createLayeredBuffers(buffers);
        int[] bufIds = this.getIds(buffers);
        int[] layeredBufIds = this.getIds(layeredBuffers);
        DBRecord record = SCHEMA.createRecord(this.table.getKey());
        record.setString(0, filename);
        record.setLongValue(1, offset);
        record.setLongValue(2, size);
        record.setField(3, (Field)new BinaryCodedField(bufIds));
        record.setField(4, (Field)new BinaryCodedField(layeredBufIds));
        this.table.putRecord(record);
        FileBytes fileBytes = new FileBytes(this, record);
        this.fileBytesList.add(fileBytes);
        return fileBytes;
    }

    @Override
    List<FileBytes> getAllFileBytes() {
        return this.fileBytesList;
    }

    @Override
    void refresh() throws IOException {
        HashMap<Long, FileBytes> map = new HashMap<Long, FileBytes>();
        ArrayList<FileBytes> newList = new ArrayList<FileBytes>();
        for (FileBytes fileBytes : this.fileBytesList) {
            map.put(fileBytes.getId(), fileBytes);
        }
        for (DBRecord record : this.table) {
            FileBytes fileBytes = (FileBytes)map.remove(record.getKey());
            if (fileBytes != null && !fileBytes.refresh(record)) {
                fileBytes.invalidate();
                fileBytes = null;
            }
            if (fileBytes == null) {
                fileBytes = new FileBytes(this, record);
            }
            newList.add(fileBytes);
        }
        for (FileBytes fileBytes : map.values()) {
            fileBytes.invalidate();
        }
        this.fileBytesList = newList;
    }

    @Override
    boolean deleteFileBytes(FileBytes fileBytes) throws IOException {
        if (this.fileBytesList.remove(fileBytes)) {
            this.table.deleteRecord(fileBytes.getId());
            fileBytes.invalidate();
            return true;
        }
        return false;
    }

    private int[] getIds(DBBuffer[] buffers) {
        int[] ids = new int[buffers.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = buffers[i].getId();
        }
        return ids;
    }

    private DBBuffer[] createLayeredBuffers(DBBuffer[] buffers) throws IOException {
        DBBuffer[] layeredBuffers = new DBBuffer[buffers.length];
        for (int i = 0; i < buffers.length; ++i) {
            layeredBuffers[i] = this.handle.createBuffer(buffers[i]);
        }
        return layeredBuffers;
    }

    private DBBuffer[] createBuffers(long size, InputStream is, TaskMonitor monitor) throws IOException {
        MonitoredInputStream mis;
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        if (is instanceof MonitoredInputStream) {
            mis = (MonitoredInputStream)is;
            mis.getTaskMonitor().initialize(size);
        } else {
            mis = new MonitoredInputStream(is, monitor).setCleanupOnCancel(true);
            monitor.initialize(size);
        }
        int maxBufSize = FileBytesAdapterV0.getMaxBufferSize();
        int bufCount = (int)(size / (long)maxBufSize);
        int sizeLastBuf = (int)(size % (long)maxBufSize);
        if (sizeLastBuf > 0) {
            ++bufCount;
        } else {
            sizeLastBuf = maxBufSize;
        }
        DBBuffer[] buffers = new DBBuffer[bufCount];
        for (int i = 0; i < bufCount - 1; ++i) {
            buffers[i] = this.handle.createBuffer(maxBufSize);
        }
        buffers[bufCount - 1] = this.handle.createBuffer(sizeLastBuf);
        try {
            for (DBBuffer buffer : buffers) {
                buffer.fill((InputStream)mis);
            }
        }
        catch (IOCancelledException e) {
            if (mis.cleanupOnCancel()) {
                monitor.initialize((long)buffers.length);
                monitor.setMessage("Cancelling...");
                monitor.setCancelEnabled(false);
                for (DBBuffer buffer : buffers) {
                    buffer.delete();
                    monitor.incrementProgress(1L);
                }
                monitor.setIndeterminate(true);
            }
            throw e;
        }
        return buffers;
    }
}

