/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.pcoderaw.VarnodeData;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.slghsymbol.PatternlessSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;
import java.util.ArrayList;

public class VarnodeSymbol
extends PatternlessSymbol {
    private VarnodeData fix = new VarnodeData();

    public VarnodeSymbol(Location location) {
        super(location);
    }

    public void markAsContext() {
    }

    public VarnodeData getFixedVarnode() {
        return this.fix;
    }

    @Override
    public int getSize() {
        return this.fix.size;
    }

    @Override
    public void collectLocalValues(ArrayList<Long> results) {
        if (this.fix.space.getType() == spacetype.IPTR_INTERNAL) {
            results.add(this.fix.offset);
        }
    }

    @Override
    public symbol_type getType() {
        return symbol_type.varnode_symbol;
    }

    public VarnodeSymbol(Location location, String nm, AddrSpace base, long offset, int size) {
        super(location, nm);
        boolean sizeError;
        int addrSize = base.getAddrSize();
        long maxByteOffset = ((long)base.getWordSize() << 8 * addrSize) - 1L;
        long endOffset = offset + (long)size - 1L;
        boolean bl = sizeError = size != 0 && Long.compareUnsigned(offset, endOffset) > 0;
        if (!sizeError && addrSize < 8) {
            boolean bl2 = sizeError = Long.compareUnsigned(endOffset, maxByteOffset) > 0;
        }
        if (sizeError) {
            throw new SleighError(nm + ":" + size + " @ " + base.getName() + ":" + String.format("0x%x", offset) + " extends beyond end of space (max offset is " + String.format("0x%x", maxByteOffset) + ")", location);
        }
        this.fix.space = base;
        this.fix.offset = offset;
        this.fix.size = size;
    }

    @Override
    public VarnodeTpl getVarnode() {
        return new VarnodeTpl(this.location, new ConstTpl(this.fix.space), new ConstTpl(ConstTpl.const_type.real, this.fix.offset), new ConstTpl(ConstTpl.const_type.real, this.fix.size));
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_VARNODE_SYM);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, this.id);
        encoder.writeSpace(SlaFormat.ATTRIB_SPACE, this.fix.space.getIndex(), this.fix.space.getName());
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_OFF, this.fix.offset);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_SIZE, this.fix.size);
        encoder.closeElement(SlaFormat.ELEM_VARNODE_SYM);
    }

    @Override
    public void encodeHeader(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_VARNODE_SYM_HEAD);
        this.encodeSleighSymbolHeader(encoder);
        encoder.closeElement(SlaFormat.ELEM_VARNODE_SYM_HEAD);
    }
}

