/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.ext4.Ext4JournalHeaderS;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4JournalSuperBlockS
implements StructConverter {
    private Ext4JournalHeaderS s_header;
    private int s_blocksize;
    private int s_maxlen;
    private int s_first;
    private int s_sequence;
    private int s_start;
    private int s_errno;
    private int s_feature_compat;
    private int s_feature_incompat;
    private int s_feature_ro_compat;
    private byte[] s_uuid;
    private int s_nr_users;
    private int s_dynsuper;
    private int s_max_transaction;
    private int s_max_trans_data;
    private byte s_checksum_type;
    private byte[] s_padding2;
    private int[] s_padding;
    private int s_checksum;
    private byte[] s_users;

    public Ext4JournalSuperBlockS(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, false));
    }

    public Ext4JournalSuperBlockS(BinaryReader reader) throws IOException {
        reader.setLittleEndian(false);
        this.s_header = new Ext4JournalHeaderS(reader);
        this.s_blocksize = reader.readNextInt();
        this.s_maxlen = reader.readNextInt();
        this.s_first = reader.readNextInt();
        this.s_sequence = reader.readNextInt();
        this.s_start = reader.readNextInt();
        this.s_errno = reader.readNextInt();
        this.s_feature_compat = reader.readNextInt();
        this.s_feature_incompat = reader.readNextInt();
        this.s_feature_ro_compat = reader.readNextInt();
        this.s_uuid = reader.readNextByteArray(16);
        this.s_nr_users = reader.readNextInt();
        this.s_dynsuper = reader.readNextInt();
        this.s_max_transaction = reader.readNextInt();
        this.s_max_trans_data = reader.readNextInt();
        this.s_checksum_type = reader.readNextByte();
        this.s_padding2 = reader.readNextByteArray(3);
        this.s_padding = reader.readNextIntArray(42);
        this.s_checksum = reader.readNextInt();
        this.s_users = reader.readNextByteArray(768);
    }

    public Ext4JournalHeaderS getS_header() {
        return this.s_header;
    }

    public int getS_blocksize() {
        return this.s_blocksize;
    }

    public int getS_maxlen() {
        return this.s_maxlen;
    }

    public int getS_first() {
        return this.s_first;
    }

    public int getS_sequence() {
        return this.s_sequence;
    }

    public int getS_start() {
        return this.s_start;
    }

    public int getS_errno() {
        return this.s_errno;
    }

    public int getS_feature_compat() {
        return this.s_feature_compat;
    }

    public int getS_feature_incompat() {
        return this.s_feature_incompat;
    }

    public int getS_feature_ro_compat() {
        return this.s_feature_ro_compat;
    }

    public byte[] getS_uuid() {
        return this.s_uuid;
    }

    public int getS_nr_users() {
        return this.s_nr_users;
    }

    public int getS_dynsuper() {
        return this.s_dynsuper;
    }

    public int getS_max_transaction() {
        return this.s_max_transaction;
    }

    public int getS_max_trans_data() {
        return this.s_max_trans_data;
    }

    public byte getS_checksum_type() {
        return this.s_checksum_type;
    }

    public byte[] getS_padding2() {
        return this.s_padding2;
    }

    public int[] getS_padding() {
        return this.s_padding;
    }

    public int getS_checksum() {
        return this.s_checksum;
    }

    public byte[] getS_users() {
        return this.s_users;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("journal_superblock_s", 0);
        structure.add(this.s_header.toDataType(), "s_header", null);
        structure.add(DWORD, "s_blocksize", null);
        structure.add(DWORD, "s_maxlen", null);
        structure.add(DWORD, "s_first", null);
        structure.add(DWORD, "s_sequence", null);
        structure.add(DWORD, "s_start", null);
        structure.add(DWORD, "s_errno", null);
        structure.add(DWORD, "s_feature_compat", null);
        structure.add(DWORD, "s_feature_incompat", null);
        structure.add(DWORD, "s_feature_ro_compat", null);
        structure.add((DataType)new ArrayDataType(BYTE, 16, BYTE.getLength()), "s_uuid", null);
        structure.add(DWORD, "s_nr_users", null);
        structure.add(DWORD, "s_dynsuper", null);
        structure.add(DWORD, "s_max_transaction", null);
        structure.add(DWORD, "s_max_trans_data", null);
        structure.add(BYTE, "s_checksum_type", null);
        structure.add((DataType)new ArrayDataType(BYTE, 3, BYTE.getLength()), "s_padding2", null);
        structure.add((DataType)new ArrayDataType(DWORD, 42, DWORD.getLength()), "s_padding", null);
        structure.add(DWORD, "s_checksum", null);
        structure.add((DataType)new ArrayDataType(BYTE, 768, BYTE.getLength()), "s_users", null);
        return structure;
    }
}

