/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.guest;

import db.DBHandle;
import ghidra.framework.data.OpenMode;
import ghidra.lifecycle.Internal;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.Language;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.guest.DBTraceGuestPlatform;
import ghidra.trace.database.guest.DBTraceGuestPlatformMappedRange;
import ghidra.trace.database.guest.InternalTracePlatform;
import ghidra.trace.model.Trace;
import ghidra.trace.model.data.TraceBasedDataTypeManager;
import ghidra.trace.model.guest.TraceGuestPlatform;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.guest.TracePlatformManager;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTracePlatformManager
implements DBTraceManager,
TracePlatformManager {
    protected final DBHandle dbh;
    protected final ReadWriteLock lock;
    protected final Language baseLanguage;
    protected final CompilerSpec baseCompilerSpec;
    protected final DBTrace trace;
    protected final DBCachedObjectStore<DBTraceGuestPlatform.DBTraceGuestLanguage> languageStore;
    protected final DBCachedObjectStore<DBTraceGuestPlatform> platformStore;
    protected final Collection<TraceGuestPlatform> platformView;
    protected final Map<Language, DBTraceGuestPlatform.DBTraceGuestLanguage> languagesByLanguage = new HashMap<Language, DBTraceGuestPlatform.DBTraceGuestLanguage>();
    protected final Map<CompilerSpec, DBTraceGuestPlatform> platformsByCompiler = new HashMap<CompilerSpec, DBTraceGuestPlatform>();
    protected final DBCachedObjectStore<DBTraceGuestPlatformMappedRange> rangeMappingStore;
    protected final InternalTracePlatform hostPlatform = new DBTraceHostPlatform();

    public DBTracePlatformManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, CompilerSpec baseCompilerSpec, DBTrace trace) throws VersionException, IOException, CancelledException {
        this.dbh = dbh;
        this.lock = lock;
        this.baseLanguage = baseCompilerSpec.getLanguage();
        this.baseCompilerSpec = baseCompilerSpec;
        this.trace = trace;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.languageStore = factory.getOrCreateCachedStore("Languages", DBTraceGuestPlatform.DBTraceGuestLanguage.class, DBTraceGuestPlatform.DBTraceGuestLanguage::new, true);
        this.platformStore = factory.getOrCreateCachedStore("Platforms", DBTraceGuestPlatform.class, (s, r) -> new DBTraceGuestPlatform(this, s, r), true);
        this.platformView = Collections.unmodifiableCollection(this.platformStore.asMap().values());
        this.rangeMappingStore = factory.getOrCreateCachedStore("LanguageMappings", DBTraceGuestPlatformMappedRange.class, (s, r) -> new DBTraceGuestPlatformMappedRange(this, s, r), true);
        this.loadLanguages();
        this.loadPlatforms(openMode, monitor);
        this.loadPlatformMappings();
    }

    protected void loadLanguages() {
        for (DBTraceGuestPlatform.DBTraceGuestLanguage languageEntry : this.languageStore.asMap().values()) {
            this.languagesByLanguage.put(languageEntry.getLanguage(), languageEntry);
        }
    }

    protected void loadPlatforms(OpenMode openMode, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        for (DBTraceGuestPlatform platformEntry : this.platformStore.asMap().values()) {
            platformEntry.loadDataTypeManager(openMode, monitor);
            this.platformsByCompiler.put(platformEntry.getCompilerSpec(), platformEntry);
        }
    }

    protected void loadPlatformMappings() {
        for (DBTraceGuestPlatformMappedRange langMapping : this.rangeMappingStore.asMap().values()) {
            DBTraceGuestPlatform mappedLanguage = (DBTraceGuestPlatform)this.platformStore.getObjectAt((long)langMapping.guestPlatformKey);
            mappedLanguage.rangesByHostAddress.put(langMapping.getHostRange().getMinAddress(), langMapping);
            mappedLanguage.rangesByGuestAddress.put(langMapping.getGuestRange().getMinAddress(), langMapping);
        }
    }

    @Internal
    protected DBTraceGuestPlatform.DBTraceGuestLanguage getOrCreateLanguage(Language language) {
        if (language == this.baseLanguage) {
            return null;
        }
        DBTraceGuestPlatform.DBTraceGuestLanguage languageEntry = this.languagesByLanguage.get(language);
        if (languageEntry == null) {
            languageEntry = (DBTraceGuestPlatform.DBTraceGuestLanguage)this.languageStore.create();
            languageEntry.set(language);
            this.languagesByLanguage.put(language, languageEntry);
        }
        return languageEntry;
    }

    @Internal
    public DBTraceGuestPlatform.DBTraceGuestLanguage getLanguageByKey(int key) {
        if (key == -1) {
            return null;
        }
        return (DBTraceGuestPlatform.DBTraceGuestLanguage)this.languageStore.getObjectAt((long)key);
    }

    @Internal
    public InternalTracePlatform getPlatformByKey(int key) {
        if (key == -1) {
            return this.hostPlatform;
        }
        return (InternalTracePlatform)this.platformStore.getObjectAt((long)key);
    }

    protected int getPlatformKeyForCompiler(CompilerSpec compiler) {
        if (Objects.equals(compiler, this.baseCompilerSpec)) {
            return -1;
        }
        return (int)this.platformsByCompiler.get(compiler).getKey();
    }

    @Internal
    public DBTraceGuestPlatform.DBTraceGuestLanguage getLanguageByLanguage(Language language) {
        if (Objects.equals(language, this.baseLanguage)) {
            return null;
        }
        return Objects.requireNonNull(this.languagesByLanguage.get(language));
    }

    protected CompilerSpec getCompilerByKey(int compilerKey) {
        if (compilerKey == -1) {
            return this.baseCompilerSpec;
        }
        return ((DBTraceGuestPlatform)this.platformStore.getObjectAt((long)compilerKey)).getCompilerSpec();
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        this.languageStore.invalidateCache();
        this.platformStore.invalidateCache();
        this.rangeMappingStore.invalidateCache();
        this.languagesByLanguage.clear();
        this.platformsByCompiler.clear();
        try {
            this.loadLanguages();
            this.loadPlatforms(OpenMode.UPDATE, TaskMonitor.DUMMY);
            this.loadPlatformMappings();
        }
        catch (CancelledException | VersionException | IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void deleteGuestPlatform(DBTraceGuestPlatform platform, TaskMonitor monitor) throws CancelledException {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            int platformKey = (int)platform.getKey();
            this.trace.getCodeManager().deletePlatform(platform, monitor);
            monitor.setMessage("Clearing guest platform range mappings");
            monitor.setMaximum((long)this.rangeMappingStore.getRecordCount());
            Iterator it = this.rangeMappingStore.asMap().values().iterator();
            while (it.hasNext()) {
                DBTraceGuestPlatformMappedRange range = (DBTraceGuestPlatformMappedRange)it.next();
                if (platformKey != range.guestPlatformKey) continue;
                it.remove();
            }
            this.platformsByCompiler.remove(platform.getCompilerSpec());
            this.platformStore.delete((DBAnnotatedObject)platform);
        }
        this.trace.setChanged(new TraceChangeRecord<DBTraceGuestPlatform, Void>(TraceEvents.PLATFORM_DELETED, null, platform));
    }

    @Override
    public InternalTracePlatform getHostPlatform() {
        return this.hostPlatform;
    }

    protected DBTraceGuestPlatform doAddGuestPlatform(CompilerSpec compilerSpec) {
        DBTraceGuestPlatform platformEntry = (DBTraceGuestPlatform)this.platformStore.create();
        platformEntry.set(compilerSpec);
        try {
            platformEntry.loadDataTypeManager(OpenMode.CREATE, TaskMonitor.DUMMY);
        }
        catch (CancelledException | VersionException | IOException e) {
            throw new AssertionError((Object)e);
        }
        this.platformsByCompiler.put(compilerSpec, platformEntry);
        return platformEntry;
    }

    @Override
    public DBTraceGuestPlatform addGuestPlatform(CompilerSpec compilerSpec) {
        DBTraceGuestPlatform platform;
        if (this.trace.getBaseCompilerSpec() == compilerSpec) {
            throw new IllegalArgumentException("Base compiler spec cannot be a guest compiler spec");
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            platform = this.doAddGuestPlatform(compilerSpec);
        }
        this.trace.setChanged(new TraceChangeRecord<DBTraceGuestPlatform, Void>(TraceEvents.PLATFORM_ADDED, null, platform));
        return platform;
    }

    @Override
    public InternalTracePlatform getPlatform(CompilerSpec compilerSpec) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            if (this.trace.getBaseCompilerSpec() == compilerSpec) {
                InternalTracePlatform internalTracePlatform = this.hostPlatform;
                return internalTracePlatform;
            }
            InternalTracePlatform internalTracePlatform = this.platformsByCompiler.get(compilerSpec);
            return internalTracePlatform;
        }
    }

    @Override
    public InternalTracePlatform getOrAddPlatform(CompilerSpec compilerSpec) {
        DBTraceGuestPlatform platform;
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            if (this.trace.getBaseCompilerSpec() == compilerSpec) {
                InternalTracePlatform internalTracePlatform = this.hostPlatform;
                return internalTracePlatform;
            }
            DBTraceGuestPlatform exists = this.platformsByCompiler.get(compilerSpec);
            if (exists != null) {
                DBTraceGuestPlatform dBTraceGuestPlatform = exists;
                return dBTraceGuestPlatform;
            }
            platform = this.doAddGuestPlatform(compilerSpec);
        }
        this.trace.setChanged(new TraceChangeRecord<DBTraceGuestPlatform, Void>(TraceEvents.PLATFORM_ADDED, null, platform));
        return platform;
    }

    @Override
    public Collection<TraceGuestPlatform> getGuestPlatforms() {
        return this.platformView;
    }

    @Internal
    public InternalTracePlatform assertMine(TracePlatform platform) {
        if (platform == this.hostPlatform) {
            return this.hostPlatform;
        }
        if (!(platform instanceof DBTraceGuestPlatform)) {
            throw new IllegalArgumentException("Given platform does not belong to this trace");
        }
        DBTraceGuestPlatform dbPlatform = (DBTraceGuestPlatform)platform;
        if (dbPlatform.manager != this) {
            throw new IllegalArgumentException("Given platform does not belong to this trace");
        }
        if (dbPlatform.isDeleted()) {
            throw new IllegalArgumentException("Given platform has been deleted");
        }
        return dbPlatform;
    }

    protected Address computeNextRegisterMin() {
        AddressRange hostRegsRange = this.hostPlatform.getRegistersRange();
        Address next = hostRegsRange == null ? this.hostPlatform.getAddressFactory().getRegisterSpace().getAddress(0L) : hostRegsRange.getMaxAddress().add(1L);
        for (DBTraceGuestPlatform guest : this.platformStore.asMap().values()) {
            Address candidateNext = guest.computeNextRegisterMin();
            if (candidateNext == null || next.compareTo((Object)candidateNext) >= 0) continue;
            next = candidateNext;
        }
        return next;
    }

    @Internal
    public class DBTraceHostPlatform
    implements InternalTracePlatform {
        @Override
        public Trace getTrace() {
            return DBTracePlatformManager.this.trace;
        }

        @Override
        public DBTraceGuestPlatform.DBTraceGuestLanguage getLanguageEntry() {
            return null;
        }

        @Override
        public int getIntKey() {
            return -1;
        }

        @Override
        public boolean isGuest() {
            return false;
        }

        @Override
        public Language getLanguage() {
            return DBTracePlatformManager.this.trace.getBaseLanguage();
        }

        @Override
        public CompilerSpec getCompilerSpec() {
            return DBTracePlatformManager.this.trace.getBaseCompilerSpec();
        }

        @Override
        public AddressFactory getAddressFactory() {
            return DBTracePlatformManager.this.trace.getBaseAddressFactory();
        }

        @Override
        public TraceBasedDataTypeManager getDataTypeManager() {
            return DBTracePlatformManager.this.trace.getBaseDataTypeManager();
        }

        @Override
        public AddressSetView getHostAddressSet() {
            return DBTracePlatformManager.this.trace.getBaseAddressFactory().getAddressSet();
        }

        @Override
        public AddressSetView getGuestAddressSet() {
            return DBTracePlatformManager.this.trace.getBaseAddressFactory().getAddressSet();
        }

        @Override
        public Address mapHostToGuest(Address hostAddress) {
            return hostAddress;
        }

        @Override
        public AddressRange mapHostToGuest(AddressRange hostRange) {
            return hostRange;
        }

        @Override
        public AddressSetView mapHostToGuest(AddressSetView hostSet) {
            return hostSet;
        }

        @Override
        public Address mapGuestToHost(Address guestAddress) {
            return guestAddress;
        }

        @Override
        public AddressRange mapGuestToHost(AddressRange guestRange) {
            return guestRange;
        }

        @Override
        public AddressSetView mapGuestToHost(AddressSetView guestSet) {
            return guestSet;
        }

        @Override
        public MemBuffer getMappedMemBuffer(long snap, Address guestAddress) {
            return DBTracePlatformManager.this.trace.getMemoryManager().getBufferAt(snap, guestAddress);
        }

        @Override
        public InstructionSet mapGuestInstructionAddressesToHost(InstructionSet set) {
            return set;
        }
    }
}

