/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.DockingWindowManager;
import docking.menu.ButtonState;
import docking.menu.DockingMenuItemUI;
import generic.theme.GThemeDefaults;
import ghidra.util.Swing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import resources.Icons;
import resources.ResourceManager;
import utility.function.Dummy;

public class MultiStateButton<T>
extends JButton {
    private Icon arrowIcon;
    private Icon disabledArrowIcon;
    private static int ARROW_WIDTH = 6;
    private static int ARROW_HEIGHT = 3;
    private static int ARROW_ICON_WIDTH = 20;
    private static int ARROW_ICON_HEIGHT = 15;
    private PopupMouseListener popupListener;
    private JPopupMenu popupMenu;
    private Rectangle arrowButtonRegion;
    private long popupLastClosedTime;
    private List<ButtonState<T>> buttonStates;
    private ButtonState<T> currentButtonState;
    private Consumer<ButtonState<T>> stateChangedConsumer = Dummy.consumer();

    public MultiStateButton(List<ButtonState<T>> buttonStates) {
        this.setButtonStates(buttonStates);
        this.installMouseListeners();
        this.arrowButtonRegion = this.createArrowRegion();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                MultiStateButton.this.arrowButtonRegion = MultiStateButton.this.createArrowRegion();
                MultiStateButton.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    Swing.runLater(() -> {
                        MultiStateButton.this.popupMenu = MultiStateButton.this.showPopup();
                    });
                    e.consume();
                }
            }
        });
    }

    public void setButtonStates(List<ButtonState<T>> buttonStates) {
        this.buttonStates = buttonStates;
        if (buttonStates.size() == 1) {
            this.arrowIcon = Icons.EMPTY_ICON;
            this.disabledArrowIcon = Icons.EMPTY_ICON;
            this.setHorizontalAlignment(0);
        } else {
            this.arrowIcon = new ArrowIcon(this);
            this.disabledArrowIcon = ResourceManager.getDisabledIcon((Icon)this.arrowIcon);
            this.setHorizontalAlignment(2);
        }
        this.setCurrentButtonState(buttonStates.get(0));
        this.arrowButtonRegion = this.createArrowRegion();
    }

    public void setStateChangedListener(Consumer<ButtonState<T>> consumer) {
        this.stateChangedConsumer = consumer;
    }

    public void setCurrentButtonState(ButtonState<T> buttonState) {
        if (!this.buttonStates.contains(buttonState)) {
            throw new IllegalArgumentException("Attempted to set button state to unknown state");
        }
        this.currentButtonState = buttonState;
        this.setText(buttonState.getButtonText());
        String tooltip = buttonState.getDescription();
        this.setToolTipText(tooltip);
        this.getAccessibleContext().setAccessibleDescription(tooltip);
        this.stateChangedConsumer.accept(buttonState);
    }

    public void setSelectedStateByClientData(T clientData) {
        for (ButtonState<T> buttonState : this.buttonStates) {
            if (!Objects.equals(clientData, buttonState.getClientData())) continue;
            this.setCurrentButtonState(buttonState);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int y = (this.getHeight() - this.arrowIcon.getIconHeight()) / 2;
        Icon icon = this.isEnabled() ? this.arrowIcon : this.disabledArrowIcon;
        icon.paintIcon(this, g, this.arrowButtonRegion.x, y);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width += this.arrowIcon.getIconWidth();
        d.height = Math.max(d.height, this.arrowIcon.getIconHeight());
        return d;
    }

    private Rectangle createArrowRegion() {
        if (this.buttonStates.size() == 1) {
            return new Rectangle(0, 0, 0, 0);
        }
        Dimension size = this.getSize();
        Border border = this.getBorder();
        int rightMargin = 3;
        if (border instanceof CompoundBorder) {
            CompoundBorder compoundBorder = (CompoundBorder)border;
            Border outsideBorder = compoundBorder.getOutsideBorder();
            Insets borderInsets = outsideBorder.getBorderInsets(this);
            rightMargin = borderInsets.right;
        }
        int w = this.arrowIcon.getIconWidth() + rightMargin;
        int h = size.height;
        return new Rectangle(size.width - w, 0, w, h);
    }

    @Override
    public void updateUI() {
        this.removeMouseListener(this.popupListener);
        super.updateUI();
        this.installMouseListeners();
    }

    private void installMouseListeners() {
        MouseListener[] mouseListeners;
        for (MouseListener mouseListener : mouseListeners = this.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
        this.popupListener = new PopupMouseListener(mouseListeners);
        this.addMouseListener(this.popupListener);
    }

    protected ActionContext getActionContext() {
        ComponentProvider provider = this.getComponentProvider();
        ActionContext context = provider == null ? null : provider.getActionContext(null);
        ActionContext actionContext = context == null ? new DefaultActionContext() : context;
        return actionContext;
    }

    private ComponentProvider getComponentProvider() {
        DockingWindowManager manager = DockingWindowManager.getActiveInstance();
        if (manager == null) {
            return null;
        }
        return manager.getActiveComponentProvider();
    }

    protected JPopupMenu showPopup() {
        if (this.popupIsShowing()) {
            this.popupMenu.setVisible(false);
            return null;
        }
        long elapsedTime = System.currentTimeMillis() - this.popupLastClosedTime;
        if (elapsedTime < 500L) {
            return null;
        }
        JPopupMenu menu = this.doCreateMenu();
        menu.addPopupMenuListener(this.popupListener);
        Point p = this.getPopupPoint();
        menu.show(this, p.x, p.y);
        return menu;
    }

    protected JPopupMenu doCreateMenu() {
        JPopupMenu menu = new JPopupMenu();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (ButtonState<T> state : this.buttonStates) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(state.getMenuText());
            item.setToolTipText(state.getDescription());
            item.getAccessibleContext().setAccessibleDescription(state.getDescription());
            item.setSelected(state == this.currentButtonState);
            buttonGroup.add(item);
            item.setUI(DockingMenuItemUI.createUI(item));
            item.addActionListener(e -> this.setCurrentButtonState(state));
            menu.add(item);
        }
        return menu;
    }

    public Point getPopupPoint() {
        Rectangle bounds = this.getBounds();
        return new Point(bounds.width - this.arrowIcon.getIconWidth(), bounds.y + bounds.height);
    }

    private boolean popupIsShowing() {
        return this.popupMenu != null && this.popupMenu.isVisible();
    }

    private class ArrowIcon
    implements Icon {
        private ArrowIcon(MultiStateButton multiStateButton) {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int arrowStartY;
            g.setColor((Color)GThemeDefaults.Colors.Messages.HINT);
            g.drawLine(x, y, x, y + ARROW_ICON_HEIGHT);
            g.setColor((Color)GThemeDefaults.Colors.FOREGROUND);
            int arrowMiddleX = x + ARROW_ICON_WIDTH / 2;
            int arrowStartX = arrowMiddleX - ARROW_WIDTH / 2;
            int arrowEndX = arrowStartX + ARROW_WIDTH;
            int arrowEndY = arrowStartY = y + ARROW_ICON_HEIGHT / 2 - ARROW_HEIGHT / 2;
            int arrowMiddleY = arrowStartY + ARROW_HEIGHT;
            int[] xPoints = new int[]{arrowStartX, arrowEndX, arrowMiddleX};
            int[] yPoints = new int[]{arrowStartY, arrowEndY, arrowMiddleY};
            Graphics2D graphics2D = (Graphics2D)g;
            graphics2D.drawPolygon(xPoints, yPoints, 3);
            graphics2D.fillPolygon(xPoints, yPoints, 3);
        }

        @Override
        public int getIconWidth() {
            return ARROW_ICON_WIDTH;
        }

        @Override
        public int getIconHeight() {
            return ARROW_ICON_HEIGHT;
        }
    }

    private class PopupMouseListener
    extends MouseAdapter
    implements PopupMenuListener {
        private final MouseListener[] parentListeners;

        public PopupMouseListener(MouseListener[] parentListeners) {
            this.parentListeners = parentListeners;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point clickPoint = e.getPoint();
            if (MultiStateButton.this.isEnabled() && MultiStateButton.this.arrowButtonRegion.contains(clickPoint)) {
                Swing.runLater(() -> {
                    MultiStateButton.this.popupMenu = MultiStateButton.this.showPopup();
                });
                e.consume();
                MultiStateButton.this.model.setPressed(false);
                MultiStateButton.this.model.setArmed(false);
                MultiStateButton.this.model.setRollover(false);
                return;
            }
            for (MouseListener listener : this.parentListeners) {
                listener.mousePressed(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MultiStateButton.this.popupIsShowing()) {
                e.consume();
                return;
            }
            for (MouseListener listener : this.parentListeners) {
                listener.mouseClicked(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (MultiStateButton.this.popupIsShowing()) {
                e.consume();
                return;
            }
            for (MouseListener listener : this.parentListeners) {
                listener.mouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (MultiStateButton.this.popupIsShowing()) {
                return;
            }
            for (MouseListener listener : this.parentListeners) {
                listener.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (MultiStateButton.this.popupIsShowing()) {
                return;
            }
            for (MouseListener listener : this.parentListeners) {
                listener.mouseExited(e);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            MultiStateButton.this.popupLastClosedTime = System.currentTimeMillis();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }
}

