/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import db.Transaction;
import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionSet;
import ghidra.app.plugin.core.debug.service.breakpoint.PlaceEmuBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.PlaceTargetBreakpointActionItem;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.breakpoint.LogicalBreakpoint;
import ghidra.debug.api.control.ControlMode;
import ghidra.debug.api.target.Target;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import utilities.util.IDHashed;

class TraceBreakpointSet {
    private final PluginTool tool;
    private final Trace trace;
    private final Address address;
    private final Set<IDHashed<TraceBreakpoint>> breakpoints = new HashSet<IDHashed<TraceBreakpoint>>();
    private Target target;
    private String emuSleigh;

    public TraceBreakpointSet(PluginTool tool, Trace trace, Address address) {
        this.tool = Objects.requireNonNull(tool);
        this.trace = Objects.requireNonNull(trace);
        this.address = Objects.requireNonNull(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
        synchronized (set) {
            return String.format("<at %s in %s: %s>", this.address, this.trace.getName(), this.breakpoints);
        }
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    private ControlMode getControlMode() {
        DebuggerControlService service = (DebuggerControlService)this.tool.getService(DebuggerControlService.class);
        return service == null ? ControlMode.DEFAULT : service.getCurrentMode(this.trace);
    }

    private long getSnap() {
        DebuggerTraceManagerService service = (DebuggerTraceManagerService)this.tool.getService(DebuggerTraceManagerService.class);
        if (service == null) {
            return (Long)this.trace.getProgramView().getViewport().getReversedSnaps().get(0);
        }
        return service.getCurrentFor(this.trace).getSnap();
    }

    public Trace getTrace() {
        return this.trace;
    }

    public Address getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicalBreakpoint.TraceMode computeMode() {
        LogicalBreakpoint.TraceMode mode = LogicalBreakpoint.TraceMode.NONE;
        Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
        synchronized (set) {
            if (this.getControlMode().useEmulatedBreakpoints()) {
                for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                    if ((mode = mode.combine(this.computeEmuMode((TraceBreakpoint)bpt.obj))) != LogicalBreakpoint.TraceMode.MISSING) continue;
                    return mode;
                }
                return mode;
            }
            for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                if ((mode = mode.combine(this.computeTargetMode((TraceBreakpoint)bpt.obj))) != LogicalBreakpoint.TraceMode.MISSING) continue;
                return mode;
            }
            return mode;
        }
    }

    public LogicalBreakpoint.TraceMode computeMode(TraceBreakpoint bpt) {
        return this.getControlMode().useEmulatedBreakpoints() ? this.computeEmuMode(bpt) : this.computeTargetMode(bpt);
    }

    public LogicalBreakpoint.TraceMode computeTargetMode(TraceBreakpoint bpt) {
        return LogicalBreakpoint.TraceMode.fromBool((boolean)bpt.isEnabled(this.getSnap()));
    }

    public LogicalBreakpoint.TraceMode computeEmuMode(TraceBreakpoint bpt) {
        return LogicalBreakpoint.TraceMode.fromBool((boolean)bpt.isEmuEnabled(this.getSnap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String computeSleigh() {
        String sleigh = null;
        long snap = this.getSnap();
        Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
        synchronized (set) {
            for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                String s = ((TraceBreakpoint)bpt.obj).getEmuSleigh(snap);
                if (sleigh != null && !sleigh.equals(s)) {
                    return null;
                }
                sleigh = s;
            }
            return sleigh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEmuSleigh(String emuSleigh) {
        this.emuSleigh = emuSleigh;
        long snap = this.getSnap();
        try (Transaction tx = this.trace.openTransaction("Set breakpoint Sleigh");){
            Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
            synchronized (set) {
                for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                    ((TraceBreakpoint)bpt.obj).setEmuSleigh(snap, emuSleigh);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
        synchronized (set) {
            return this.breakpoints.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TraceBreakpoint> getBreakpoints() {
        Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
        synchronized (set) {
            return this.breakpoints.stream().map(e -> (TraceBreakpoint)e.obj).collect(Collectors.toUnmodifiableSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(TraceBreakpoint bpt) {
        long snap = this.getSnap();
        if ("emu_swi();\nemu_exec_decoded();\n".equals(bpt.getEmuSleigh(snap)) && this.emuSleigh != null) {
            try (Transaction tx = this.trace.openTransaction("Set breakpoint Sleigh");){
                bpt.setEmuSleigh(snap, this.emuSleigh);
            }
        }
        Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
        synchronized (set) {
            return this.breakpoints.add((IDHashed<TraceBreakpoint>)new IDHashed((Object)bpt));
        }
    }

    public boolean canMerge(TraceBreakpoint bpt) {
        if (this.trace != bpt.getTrace()) {
            return false;
        }
        return this.address.equals((Object)bpt.getMinAddress(this.getSnap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(TraceBreakpoint bpt) {
        Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
        synchronized (set) {
            return this.breakpoints.remove(new IDHashed((Object)bpt));
        }
    }

    public void planEnable(BreakpointActionSet actions, long length, Collection<TraceBreakpointKind> kinds) {
        long snap = this.getSnap();
        if (this.isEmpty()) {
            if (this.target == null || this.getControlMode().useEmulatedBreakpoints()) {
                this.planPlaceEmu(actions, snap, length, kinds);
            } else {
                this.planPlaceTarget(actions, snap, length, kinds);
            }
        } else if (this.target == null || this.getControlMode().useEmulatedBreakpoints()) {
            this.planEnableEmu(actions);
        } else {
            this.planEnableTarget(actions);
        }
    }

    private void planPlaceTarget(BreakpointActionSet actions, long snap, long length, Collection<TraceBreakpointKind> kinds) {
        if (snap != this.target.getSnap()) {
            throw new AssertionError((Object)"Target breakpoints must be requested at present snap");
        }
        actions.add(new PlaceTargetBreakpointActionItem(this.target, BreakpointActionItem.range(this.address, length), kinds));
    }

    private void planPlaceEmu(BreakpointActionSet actions, long snap, long length, Collection<TraceBreakpointKind> kinds) {
        actions.add(new PlaceEmuBreakpointActionItem(this.trace, snap, this.address, length, Set.copyOf(kinds), this.emuSleigh));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void planEnableTarget(BreakpointActionSet actions) {
        Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
        synchronized (set) {
            for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                actions.planEnableTarget(this.target, (TraceBreakpoint)bpt.obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void planEnableEmu(BreakpointActionSet actions) {
        Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
        synchronized (set) {
            for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                actions.planEnableEmu((TraceBreakpoint)bpt.obj, this.getSnap());
            }
        }
    }

    public void planDisable(BreakpointActionSet actions, long length, Collection<TraceBreakpointKind> kinds) {
        if (this.getControlMode().useEmulatedBreakpoints()) {
            this.planDisableEmu(actions);
        } else {
            this.planDisableTarget(actions, length, kinds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void planDisableTarget(BreakpointActionSet actions, long length, Collection<TraceBreakpointKind> kinds) {
        Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
        synchronized (set) {
            for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                actions.planDisableTarget(this.target, (TraceBreakpoint)bpt.obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void planDisableEmu(BreakpointActionSet actions) {
        Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
        synchronized (set) {
            for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                actions.planDisableEmu((TraceBreakpoint)bpt.obj, this.getSnap());
            }
        }
    }

    public void planDelete(BreakpointActionSet actions, long length, Set<TraceBreakpointKind> kinds) {
        if (this.getControlMode().useEmulatedBreakpoints()) {
            this.planDeleteEmu(actions);
        } else {
            this.planDeleteTarget(actions, length, kinds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void planDeleteTarget(BreakpointActionSet actions, long length, Set<TraceBreakpointKind> kinds) {
        Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
        synchronized (set) {
            for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                actions.planDeleteTarget(this.target, (TraceBreakpoint)bpt.obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void planDeleteEmu(BreakpointActionSet actions) {
        Set<IDHashed<TraceBreakpoint>> set = this.breakpoints;
        synchronized (set) {
            for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                actions.planDeleteEmu((TraceBreakpoint)bpt.obj, this.getSnap());
            }
        }
    }
}

