/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext.databasesearcher;

import ghidra.app.plugin.core.navigation.FunctionUtils;
import ghidra.app.plugin.core.searchtext.Searcher;
import ghidra.app.plugin.core.searchtext.databasesearcher.ProgramDatabaseFieldSearcher;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.FunctionRepeatableCommentFieldLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableCommentFieldLocation;
import ghidra.program.util.VariableLocFieldLocation;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.program.util.VariableTypeFieldLocation;
import ghidra.util.StringUtilities;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionFieldSearcher
extends ProgramDatabaseFieldSearcher {
    private FunctionIterator iterator;
    private Program program;

    public FunctionFieldSearcher(Program program, ProgramLocation startLoc, AddressSetView set, boolean forward, Pattern pattern) {
        super(pattern, forward, startLoc, set);
        this.program = program;
        this.iterator = set != null ? program.getListing().getFunctions(set, forward) : program.getListing().getFunctions(startLoc.getAddress(), forward);
    }

    @Override
    protected Address advance(List<Searcher.TextSearchResult> currentMatches) {
        if (this.iterator.hasNext()) {
            Function function = (Function)this.iterator.next();
            Address nextAddress = null;
            if (function != null && !function.isExternal()) {
                nextAddress = function.getEntryPoint();
                this.findMatchesForCurrentFunction(function, currentMatches);
            }
            return nextAddress;
        }
        return null;
    }

    private void findMatchesForCurrentFunction(Function function, List<Searcher.TextSearchResult> currentMatches) {
        this.findCommentMatches(function, currentMatches);
        this.findSignatureMatches(function, currentMatches);
        this.findVariableMatches(function, currentMatches);
    }

    private void findVariableMatches(Function function, List<Searcher.TextSearchResult> currentMatches) {
        Variable[] localVariables;
        Parameter[] parameters;
        for (Parameter parameter : parameters = function.getParameters()) {
            this.checkTypeString((Variable)parameter, currentMatches);
            this.checkName((Variable)parameter, currentMatches);
            this.checkStorage((Variable)parameter, currentMatches);
            this.checkComment((Variable)parameter, currentMatches);
        }
        for (Variable localVariable : localVariables = function.getLocalVariables()) {
            this.checkTypeString(localVariable, currentMatches);
            this.checkName(localVariable, currentMatches);
            this.checkStorage(localVariable, currentMatches);
            this.checkComment(localVariable, currentMatches);
        }
    }

    private void checkTypeString(Variable variable, List<Searcher.TextSearchResult> currentMatches) {
        DataType dt = variable instanceof Parameter ? ((Parameter)variable).getFormalDataType() : variable.getDataType();
        if (dt == null) {
            return;
        }
        String searchString = dt.getDisplayName();
        Matcher matcher = this.pattern.matcher(searchString);
        while (matcher.find()) {
            int index = matcher.start();
            currentMatches.add(new Searcher.TextSearchResult((ProgramLocation)new VariableTypeFieldLocation(this.program, variable, index), index));
        }
    }

    private void checkName(Variable variable, List<Searcher.TextSearchResult> currentMatches) {
        String searchString = variable.getName();
        Matcher matcher = this.pattern.matcher(searchString);
        while (matcher.find()) {
            int index = matcher.start();
            currentMatches.add(new Searcher.TextSearchResult((ProgramLocation)new VariableNameFieldLocation(this.program, variable, index), index));
        }
    }

    private void checkStorage(Variable var, List<Searcher.TextSearchResult> currentMatches) {
        String searchString = var.getVariableStorage().toString();
        Matcher matcher = this.pattern.matcher(searchString);
        while (matcher.find()) {
            int index = matcher.start();
            currentMatches.add(new Searcher.TextSearchResult((ProgramLocation)new VariableLocFieldLocation(this.program, var, index), index));
        }
    }

    private void checkComment(Variable variable, List<Searcher.TextSearchResult> currentMatches) {
        String searchString = variable.getComment();
        if (searchString == null) {
            return;
        }
        Matcher matcher = this.pattern.matcher(searchString);
        while (matcher.find()) {
            int index = matcher.start();
            currentMatches.add(new Searcher.TextSearchResult((ProgramLocation)new VariableCommentFieldLocation(this.program, variable, index), index));
        }
    }

    private void findSignatureMatches(Function function, List<Searcher.TextSearchResult> currentMatches) {
        String signature = function.getPrototypeString(false, false);
        Matcher matcher = this.pattern.matcher(signature);
        Address address = function.getEntryPoint();
        int callingConventionOffset = FunctionUtils.getCallingConventionSignatureOffset(function);
        while (matcher.find()) {
            int index = matcher.start();
            currentMatches.add(new Searcher.TextSearchResult((ProgramLocation)new FunctionSignatureFieldLocation(this.program, address, null, index + callingConventionOffset, signature), index));
        }
    }

    private void findCommentMatches(Function function, List<Searcher.TextSearchResult> currentMatches) {
        String functionComment = function.getRepeatableComment();
        if (functionComment == null) {
            return;
        }
        String cleanedUpComment = functionComment.replace('\n', ' ');
        Matcher matcher = this.pattern.matcher(cleanedUpComment);
        Address address = function.getEntryPoint();
        while (matcher.find()) {
            int index = matcher.start();
            currentMatches.add(new Searcher.TextSearchResult(this.getFunctionCommentLocation(functionComment, index, address), index));
        }
    }

    private ProgramLocation getFunctionCommentLocation(String comment, int index, Address address) {
        String[] comments = StringUtilities.toLines((String)comment);
        int rowIndex = this.findRowIndex(comments, index);
        int charOffset = this.findCharOffset(index, rowIndex, comments);
        return new FunctionRepeatableCommentFieldLocation(this.program, address, comments, rowIndex, charOffset);
    }

    private int findCharOffset(int index, int rowIndex, String[] opStrings) {
        int totalBeforeOpIndex = 0;
        for (int i = 0; i < rowIndex; ++i) {
            totalBeforeOpIndex += opStrings[i].length();
        }
        return index - totalBeforeOpIndex;
    }

    private int findRowIndex(String[] commentStrings, int index) {
        int totalSoFar = 0;
        for (int i = 0; i < commentStrings.length; ++i) {
            if (index >= totalSoFar + commentStrings[i].length()) continue;
            return i;
        }
        return commentStrings.length - 1;
    }
}

