/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.math.geom.plane;

import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.AffineTransform;
import com.jogamp.math.geom.plane.Crossing2F;
import com.jogamp.math.geom.plane.IllegalPathStateException;
import com.jogamp.math.geom.plane.Winding;
import com.jogamp.math.geom.plane.WindingRule;
import java.io.PrintStream;
import java.util.NoSuchElementException;

public final class Path2F {
    static final String invalidWindingRuleValue = "Invalid winding rule value";
    static final String iteratorOutOfBounds = "Iterator out of bounds";
    private static final int BUFFER_SIZE = 10;
    private static final int BUFFER_CAPACITY = 10;
    private byte[] m_types;
    private float[] m_points;
    private int m_typeSize;
    private int m_pointSize;
    private WindingRule m_rule;

    public Path2F() {
        this(WindingRule.NON_ZERO, 10, 10);
    }

    public Path2F(WindingRule windingRule) {
        this(windingRule, 10, 10);
    }

    public Path2F(WindingRule windingRule, int n) {
        this(windingRule, n, n);
    }

    public Path2F(WindingRule windingRule, int n, int n2) {
        this.setWindingRule(windingRule);
        this.m_types = new byte[n];
        this.m_points = new float[n2 * 2];
    }

    public Path2F(Path2F path2F) {
        this(WindingRule.NON_ZERO, 10);
        Iterator iterator = path2F.iterator(null);
        this.setWindingRule(iterator.getWindingRule());
        this.append(iterator, false);
    }

    public void setWindingRule(WindingRule windingRule) {
        this.m_rule = windingRule;
    }

    public WindingRule getWindingRule() {
        return this.m_rule;
    }

    private void checkBuf(int n, boolean bl) {
        Object[] objectArray;
        if (bl && this.m_typeSize == 0) {
            throw new IllegalPathStateException("First segment should be SEG_MOVETO type");
        }
        if (this.m_typeSize == this.m_types.length) {
            objectArray = new byte[this.m_typeSize + 10];
            System.arraycopy(this.m_types, 0, objectArray, 0, this.m_typeSize);
            this.m_types = objectArray;
        }
        if (this.m_pointSize + n > this.m_points.length) {
            objectArray = new float[this.m_pointSize + Math.max(20, n)];
            System.arraycopy(this.m_points, 0, objectArray, 0, this.m_pointSize);
            this.m_points = objectArray;
        }
    }

    public void moveTo(float f, float f2) {
        if (this.m_typeSize > 0 && this.m_types[this.m_typeSize - 1] == SegmentType.MOVETO.integer()) {
            this.m_points[this.m_pointSize - 2] = f;
            this.m_points[this.m_pointSize - 1] = f2;
        } else {
            this.checkBuf(2, false);
            this.m_types[this.m_typeSize++] = SegmentType.MOVETO.integer();
            this.m_points[this.m_pointSize++] = f;
            this.m_points[this.m_pointSize++] = f2;
        }
    }

    public void lineTo(float f, float f2) {
        this.checkBuf(2, true);
        this.m_types[this.m_typeSize++] = SegmentType.LINETO.integer();
        this.m_points[this.m_pointSize++] = f;
        this.m_points[this.m_pointSize++] = f2;
    }

    public void quadTo(float f, float f2, float f3, float f4) {
        this.checkBuf(4, true);
        this.m_types[this.m_typeSize++] = SegmentType.QUADTO.integer();
        this.m_points[this.m_pointSize++] = f;
        this.m_points[this.m_pointSize++] = f2;
        this.m_points[this.m_pointSize++] = f3;
        this.m_points[this.m_pointSize++] = f4;
    }

    public void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.checkBuf(6, true);
        this.m_types[this.m_typeSize++] = SegmentType.CUBICTO.integer();
        this.m_points[this.m_pointSize++] = f;
        this.m_points[this.m_pointSize++] = f2;
        this.m_points[this.m_pointSize++] = f3;
        this.m_points[this.m_pointSize++] = f4;
        this.m_points[this.m_pointSize++] = f5;
        this.m_points[this.m_pointSize++] = f6;
    }

    public void closePath() {
        if (!this.isClosed()) {
            this.checkBuf(0, true);
            this.m_types[this.m_typeSize++] = SegmentType.CLOSE.integer();
        }
    }

    public final int size() {
        return this.m_typeSize;
    }

    public final boolean isClosed() {
        return this.m_typeSize > 0 && this.m_types[this.m_typeSize - 1] == SegmentType.CLOSE.integer();
    }

    public Winding getWinding() {
        return this.iterator(null).getWinding();
    }

    public String toString() {
        return "[size " + this.size() + ", closed " + this.isClosed() + ", winding[rule " + (Object)((Object)this.getWindingRule()) + ", " + (Object)((Object)this.getWinding()) + "]]";
    }

    public void append(Path2F path2F, boolean bl) {
        this.append(path2F.iterator(null), bl);
    }

    public void append(Iterator iterator, boolean bl) {
        float[] fArray = iterator.points();
        while (iterator.hasNext()) {
            int n = iterator.index();
            SegmentType segmentType = iterator.next();
            switch (segmentType.ordinal()) {
                case 0: {
                    if (!bl || 0 == this.m_typeSize) {
                        this.moveTo(fArray[n + 0], fArray[n + 1]);
                        break;
                    }
                    if (this.m_types[this.m_typeSize - 1] != SegmentType.CLOSE.integer() && this.m_points[this.m_pointSize - 2] == fArray[n + 0] && this.m_points[this.m_pointSize - 1] == fArray[n + 1]) break;
                }
                case 1: {
                    this.lineTo(fArray[n + 0], fArray[n + 1]);
                    break;
                }
                case 2: {
                    this.quadTo(fArray[n + 0], fArray[n + 1], fArray[n + 2], fArray[n + 3]);
                    break;
                }
                case 3: {
                    this.cubicTo(fArray[n + 0], fArray[n + 1], fArray[n + 2], fArray[n + 3], fArray[n + 4], fArray[n + 5]);
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            bl = false;
        }
    }

    public void printSegments(PrintStream printStream) {
        Iterator iterator = this.iterator();
        float[] fArray = iterator.points();
        int n = 0;
        while (iterator.hasNext()) {
            int n2 = iterator.index();
            SegmentType segmentType = iterator.next();
            switch (segmentType.ordinal()) {
                case 0: {
                    printStream.printf("%2d: moveTo(%.4f/%.4f)%n", n, Float.valueOf(fArray[n2 + 0]), Float.valueOf(fArray[n2 + 1]));
                    break;
                }
                case 1: {
                    printStream.printf("%2d: lineTo(%.4f/%.4f)%n", n, Float.valueOf(fArray[n2 + 0]), Float.valueOf(fArray[n2 + 1]));
                    break;
                }
                case 2: {
                    printStream.printf("%2d: quadTo(%.4f/%.4f, %.4f/%.4f)%n", n, Float.valueOf(fArray[n2 + 0]), Float.valueOf(fArray[n2 + 1]), Float.valueOf(fArray[n2 + 2]), Float.valueOf(fArray[n2 + 3]));
                    break;
                }
                case 3: {
                    printStream.printf("%2d: cubicTo(%.4f/%.4f, %.4f/%.4f, %.4f/%.4f)%n", n, Float.valueOf(fArray[n2 + 0]), Float.valueOf(fArray[n2 + 1]), Float.valueOf(fArray[n2 + 2]), Float.valueOf(fArray[n2 + 3]), Float.valueOf(fArray[n2 + 4]), Float.valueOf(fArray[n2 + 5]));
                    break;
                }
                case 4: {
                    printStream.printf("%2d: closePath()%n", n);
                }
            }
            ++n;
        }
    }

    public void reset() {
        this.m_typeSize = 0;
        this.m_pointSize = 0;
    }

    public void transform(AffineTransform affineTransform) {
        affineTransform.transform(this.m_points, 0, this.m_points, 0, this.m_pointSize / 2);
    }

    public Path2F createTransformedShape(AffineTransform affineTransform) {
        Path2F path2F = new Path2F(this);
        if (affineTransform != null) {
            path2F.transform(affineTransform);
        }
        return path2F;
    }

    public final synchronized AABBox getBounds2D() {
        float f;
        float f2;
        float f3;
        float f4;
        if (this.m_pointSize == 0) {
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = 0.0f;
            f = 0.0f;
        } else {
            int n = this.m_pointSize - 1;
            f2 = f4 = this.m_points[n--];
            f = f3 = this.m_points[n--];
            while (n > 0) {
                float f5 = this.m_points[n--];
                int n2 = n--;
                float f6 = this.m_points[n2];
                if (f6 < f) {
                    f = f6;
                } else if (f6 > f3) {
                    f3 = f6;
                }
                if (f5 < f2) {
                    f2 = f5;
                    continue;
                }
                if (!(f5 > f4)) continue;
                f4 = f5;
            }
        }
        return new AABBox(f, f2, 0.0f, f3, f4, 0.0f);
    }

    boolean isInside(int n) {
        if (this.m_rule == WindingRule.NON_ZERO) {
            return Crossing2F.isInsideNonZero(n);
        }
        return Crossing2F.isInsideEvenOdd(n);
    }

    public boolean contains(float f, float f2) {
        return this.isInside(Crossing2F.crossShape(this, f, f2));
    }

    public boolean contains(float f, float f2, float f3, float f4) {
        int n = Crossing2F.intersectShape(this, f, f2, f3, f4);
        return n != 255 && this.isInside(n);
    }

    public boolean intersects(float f, float f2, float f3, float f4) {
        int n = Crossing2F.intersectShape(this, f, f2, f3, f4);
        return n == 255 || this.isInside(n);
    }

    public boolean contains(AABBox aABBox) {
        return this.contains(aABBox.getMinX(), aABBox.getMinY(), aABBox.getWidth(), aABBox.getHeight());
    }

    public boolean intersects(AABBox aABBox) {
        return this.intersects(aABBox.getMinX(), aABBox.getMinY(), aABBox.getWidth(), aABBox.getHeight());
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public Iterator iterator(AffineTransform affineTransform) {
        return new Iterator(this, affineTransform);
    }

    public static final class Iterator {
        private final Path2F p;
        private final AffineTransform t;
        private int typeIndex;
        private int pointIndex;

        Iterator(Path2F path2F) {
            this(path2F, null);
        }

        public Iterator(Path2F path2F, AffineTransform affineTransform) {
            this.p = path2F;
            this.t = affineTransform;
            this.reset();
        }

        private void reset() {
            this.typeIndex = 0;
            this.pointIndex = 0;
        }

        public WindingRule getWindingRule() {
            return this.p.getWindingRule();
        }

        public Winding getWinding() {
            return this.area() >= 0.0f ? Winding.CCW : Winding.CW;
        }

        public float[] points() {
            return this.p.m_points;
        }

        public int index() {
            return this.pointIndex;
        }

        public SegmentType getType() {
            return SegmentType.valueOf(this.p.m_types[this.typeIndex]);
        }

        @Deprecated
        public SegmentType currentSegment(float[] fArray) {
            if (!this.hasNext()) {
                throw new NoSuchElementException(Path2F.iteratorOutOfBounds);
            }
            SegmentType segmentType = this.getType();
            int n = segmentType.point_count;
            System.arraycopy(this.p.m_points, this.pointIndex, fArray, 0, n * 2);
            if (this.t != null) {
                this.t.transform(fArray, 0, fArray, 0, n);
            }
            return segmentType;
        }

        public boolean hasNext() {
            return this.typeIndex < this.p.m_typeSize;
        }

        public SegmentType next() {
            SegmentType segmentType = this.getType();
            this.pointIndex += 2 * segmentType.point_count;
            ++this.typeIndex;
            return segmentType;
        }

        private float area() {
            float f = 0.0f;
            float[] fArray = this.points();
            float[] fArray2 = new float[2];
            while (this.hasNext()) {
                int n = this.index();
                SegmentType segmentType = this.next();
                switch (segmentType.ordinal()) {
                    case 0: {
                        fArray2[0] = fArray[n + 0];
                        fArray2[1] = fArray[n + 1];
                        break;
                    }
                    case 1: {
                        f += fArray2[0] * fArray[n + 1] - fArray[n + 0] * fArray2[1];
                        fArray2[0] = fArray[n + 0];
                        fArray2[1] = fArray[n + 1];
                        break;
                    }
                    case 2: {
                        f += fArray2[0] * fArray[n + 1] - fArray[n + 0] * fArray2[1];
                        f += fArray[n + 0] * fArray[n + 3] - fArray[n + 2] * fArray[n + 1];
                        fArray2[0] = fArray[n + 2];
                        fArray2[1] = fArray[n + 3];
                        break;
                    }
                    case 3: {
                        f += fArray2[0] * fArray[n + 1] - fArray[n + 0] * fArray2[1];
                        f += fArray[n + 0] * fArray[n + 3] - fArray[n + 2] * fArray[n + 1];
                        f += fArray[n + 2] * fArray[n + 5] - fArray[n + 4] * fArray[n + 3];
                        fArray2[0] = fArray[n + 4];
                        fArray2[1] = fArray[n + 5];
                        break;
                    }
                }
            }
            this.reset();
            return f;
        }
    }

    public static enum SegmentType {
        MOVETO(1),
        LINETO(1),
        QUADTO(2),
        CUBICTO(3),
        CLOSE(0);

        public final int point_count;

        public byte integer() {
            return (byte)this.ordinal();
        }

        public static SegmentType valueOf(int n) {
            switch (n) {
                case 0: {
                    return MOVETO;
                }
                case 1: {
                    return LINETO;
                }
                case 2: {
                    return QUADTO;
                }
                case 3: {
                    return CUBICTO;
                }
                case 4: {
                    return CLOSE;
                }
            }
            throw new IllegalArgumentException("Unhandled Segment Type: " + n);
        }

        public static int getPointCount(int n) {
            switch (n) {
                case 0: {
                    return SegmentType.MOVETO.point_count;
                }
                case 1: {
                    return SegmentType.LINETO.point_count;
                }
                case 2: {
                    return SegmentType.QUADTO.point_count;
                }
                case 3: {
                    return SegmentType.CUBICTO.point_count;
                }
                case 4: {
                    return SegmentType.CLOSE.point_count;
                }
            }
            throw new IllegalArgumentException("Unhandled Segment Type: " + n);
        }

        private SegmentType(int n2) {
            this.point_count = n2;
        }
    }
}

