/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.font;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.AffineTransform;

public interface Font {
    public static final int NAME_COPYRIGHT = 0;
    public static final int NAME_FAMILY = 1;
    public static final int NAME_SUBFAMILY = 2;
    public static final int NAME_UNIQUNAME = 3;
    public static final int NAME_FULLNAME = 4;
    public static final int NAME_VERSION = 5;
    public static final int NAME_MANUFACTURER = 8;
    public static final int NAME_DESIGNER = 9;

    public static String getUTF16String(char c) {
        return Character.toString(c);
    }

    public static Font getBestCoverage(Font font, Font font2, CharSequence charSequence) {
        if (null != font && null != font2) {
            return font.getDefinedCount(charSequence) >= font2.getDefinedCount(charSequence) ? font : font2;
        }
        if (null != font) {
            return font;
        }
        return font2;
    }

    public String getName(int var1);

    public String getFullFamilyName();

    public StringBuilder getAllNames(StringBuilder var1, String var2);

    public int hashCode();

    public boolean equals(Object var1);

    public int getAdvanceWidthFU(int var1);

    public float getAdvanceWidth(int var1);

    public Metrics getMetrics();

    public int getGlyphCount();

    public int getDefinedCount(CharSequence var1);

    public char getGlyphCodepoint(String var1);

    public String getUTF16String(String var1);

    public int getGlyphID(char var1);

    public Glyph getGlyph(String var1);

    public Glyph getGlyph(char var1);

    public Glyph getGlyph(int var1);

    public void forAllCodepoints(CodepointIDVisitor var1);

    public void forAllGlyphs(GlyphVisitor2 var1);

    public int getLineHeightFU();

    public float getLineHeight();

    public AABBox getMetricBoundsFU(CharSequence var1);

    public AABBox getMetricBounds(CharSequence var1);

    public AABBox getGlyphBounds(CharSequence var1);

    public AABBox getGlyphBounds(CharSequence var1, AffineTransform var2, AffineTransform var3);

    public AABBox getGlyphBoundsFU(CharSequence var1);

    public AABBox getGlyphBoundsFU(CharSequence var1, AffineTransform var2, AffineTransform var3);

    public AABBox getGlyphShapeBounds(AffineTransform var1, CharSequence var2);

    public AABBox getGlyphShapeBounds(AffineTransform var1, CharSequence var2, AffineTransform var3, AffineTransform var4);

    public boolean isPrintableChar(char var1);

    public AABBox processString(GlyphVisitor var1, AffineTransform var2, CharSequence var3);

    public AABBox processString(GlyphVisitor var1, AffineTransform var2, CharSequence var3, AffineTransform var4, AffineTransform var5);

    public void processString(GlyphVisitor2 var1, CharSequence var2);

    public String toString();

    public String fullString();

    public static interface CodepointIDVisitor {
        public void visit(char var1, int var2);
    }

    public static interface Glyph {
        public static final int ID_UNKNOWN = 0;

        public Font getFont();

        public char getCodepoint();

        public int getID();

        public String getName();

        public boolean isUndefined();

        public boolean isWhitespace();

        public boolean isNonContour();

        public AABBox getBoundsFU();

        public AABBox getBoundsFU(AABBox var1);

        public AABBox getBounds(AABBox var1);

        public AABBox getBounds();

        public int getAdvanceWidthFU();

        public float getAdvanceWidth();

        public int getLeftSideBearingsFU();

        public float getLeftSideBearings();

        public boolean isKerningHorizontal();

        public boolean isKerningCrossstream();

        public int getKerningPairCount();

        public int getKerningFU(int var1);

        public float getKerning(int var1);

        public OutlineShape getShape();

        public int hashCode();

        public String toString();

        public String fullString();
    }

    public static interface GlyphVisitor {
        public void visit(Glyph var1, AffineTransform var2);
    }

    public static interface GlyphVisitor2 {
        public void visit(Glyph var1);
    }

    public static interface Metrics {
        public int getAscentFU();

        public float getAscent();

        public int getDescentFU();

        public float getDescent();

        public int getLineGapFU();

        public float getLineGap();

        public int getMaxExtendFU();

        public float getMaxExtend();

        public int getUnitsPerEM();

        public float getScale(int var1);

        public AABBox getBoundsFU(AABBox var1);

        public AABBox getBounds(AABBox var1);
    }
}

