/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.generic;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.freeplane.core.ui.menubuilders.generic.BuilderDestroyerPair;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;

public class RecursiveMenuStructureProcessor {
    public static final String PROCESS_ON_POPUP = "processOnPopup";
    public static final String UI = "UI";
    private final Map<String, BuilderDestroyerPair> visitors;
    private final Map<String, String> subtreeDefaultVisitors;
    private LinkedList<String> subtreeDefaultVisitorStack;
    private BuilderDestroyerPair defaultBuilder = new BuilderDestroyerPair(EntryVisitor.ILLEGAL, EntryVisitor.ILLEGAL);

    private RecursiveMenuStructureProcessor(Map<String, BuilderDestroyerPair> visitors, Map<String, String> subtreeDefaultVisitors, BuilderDestroyerPair defaultBuilder) {
        this.visitors = visitors;
        this.subtreeDefaultVisitors = subtreeDefaultVisitors;
        this.subtreeDefaultVisitorStack = new LinkedList();
        this.defaultBuilder = defaultBuilder;
    }

    public RecursiveMenuStructureProcessor() {
        this.visitors = new HashMap<String, BuilderDestroyerPair>();
        this.subtreeDefaultVisitors = new HashMap<String, String>();
        this.subtreeDefaultVisitorStack = new LinkedList();
    }

    public void addBuilderPair(String name, BuilderDestroyerPair pair) {
        this.visitors.put(name, pair);
    }

    public void addBuilderPair(String name, EntryVisitor builder, EntryVisitor destroyer) {
        this.addBuilderPair(name, new BuilderDestroyerPair(builder, destroyer));
    }

    public void addBuilder(String name, EntryVisitor builder) {
        this.addBuilderPair(name, new BuilderDestroyerPair(builder));
    }

    public void build(Entry target) {
        this.process(target, BuilderDestroyerPair.VisitorType.BUILDER);
    }

    private void process(Entry target, BuilderDestroyerPair.VisitorType visitorType) {
        BuilderDestroyerPair builderDestroyerPair = this.builderDestroyerPair(target);
        this.process(target, builderDestroyerPair, visitorType);
    }

    private void process(Entry target, BuilderDestroyerPair builderDestroyerPair, BuilderDestroyerPair.VisitorType visitorType) {
        EntryVisitor visitor = builderDestroyerPair.get(visitorType);
        boolean shouldSkipChildren = visitor.shouldSkipChildren(target);
        visitor.visit(target);
        if (!shouldSkipChildren && !RecursiveMenuStructureProcessor.shouldProcessOnEvent(target)) {
            this.processChildren(target, visitorType);
        }
    }

    public void destroy(Entry target) {
        this.process(target, BuilderDestroyerPair.VisitorType.DESTROYER);
    }

    public static boolean shouldProcessOnEvent(Entry target) {
        return Boolean.TRUE.equals(target.getAttribute(PROCESS_ON_POPUP));
    }

    public static boolean shouldProcessUiOnEvent(Entry target) {
        return RecursiveMenuStructureProcessor.shouldProcessOnEvent(target) || UI.equals(target.getAttribute(PROCESS_ON_POPUP));
    }

    private void processChildren(Entry target, BuilderDestroyerPair.VisitorType visitorType) {
        int originalDefaultBuilderStackSize = this.subtreeDefaultVisitorStack.size();
        String visitorToCall = this.visitorToCall(target);
        if (visitorToCall != null) {
            this.changeDefaultBuilder(visitorToCall);
        }
        List<Entry> children = target.children();
        for (Entry child : children.toArray(new Entry[children.size()])) {
            this.process(child, visitorType);
        }
        if (originalDefaultBuilderStackSize < this.subtreeDefaultVisitorStack.size()) {
            this.subtreeDefaultVisitorStack.removeLast();
        }
    }

    private BuilderDestroyerPair builderDestroyerPair(Entry target) {
        String builderToCall = this.visitorToCall(target);
        BuilderDestroyerPair builder = builderToCall != null ? this.visitors.get(builderToCall) : this.defaultBuilder;
        return builder;
    }

    private void changeDefaultBuilder(String calledBuilder) {
        String defaultBuilder = this.subtreeDefaultVisitors.get(calledBuilder);
        if (defaultBuilder != null && (this.subtreeDefaultVisitorStack.isEmpty() || !this.subtreeDefaultVisitorStack.getLast().equals(defaultBuilder))) {
            this.subtreeDefaultVisitorStack.addLast(defaultBuilder);
        }
    }

    private String visitorToCall(Entry target) {
        String explicitBuilderName = this.explicitBuilderName(target);
        if (explicitBuilderName != null) {
            return explicitBuilderName;
        }
        if (this.subtreeDefaultVisitorStack.isEmpty()) {
            return null;
        }
        return this.subtreeDefaultVisitorStack.getLast();
    }

    public void setSubtreeDefaultBuilderPair(String builder, String subtreeBuilder) {
        this.subtreeDefaultVisitors.put(builder, subtreeBuilder);
    }

    public void setDefaultBuilder(EntryVisitor defaultBuilder) {
        this.setDefaultBuilderPair(new BuilderDestroyerPair(defaultBuilder, EntryVisitor.EMTPY));
    }

    public void setDefaultBuilderPair(EntryVisitor defaultBuilder, EntryVisitor defaultDestroyer) {
        this.setDefaultBuilderPair(new BuilderDestroyerPair(defaultBuilder, defaultDestroyer));
    }

    private void setDefaultBuilderPair(BuilderDestroyerPair pair) {
        this.defaultBuilder = pair;
    }

    public BuilderDestroyerPair findSubtreeChildrenDefaultBuilder(Entry root, Entry entry) {
        Entry explicitDefaultBuilderEntry = this.explicitDefaultBuilderEntry(root, entry);
        if (explicitDefaultBuilderEntry != null) {
            String builderName = this.explicitBuilderName(explicitDefaultBuilderEntry);
            int count = 1;
            for (Entry index = entry; index != explicitDefaultBuilderEntry; index = index.getParent()) {
                ++count;
            }
            for (int i = 0; i < count; ++i) {
                String nextExplicitDefaultBuilderName = this.subtreeDefaultVisitors.get(builderName);
                if (nextExplicitDefaultBuilderName == null) continue;
                builderName = nextExplicitDefaultBuilderName;
            }
            return this.visitors.get(builderName);
        }
        return this.defaultBuilder;
    }

    private Entry explicitDefaultBuilderEntry(Entry root, Entry entry) {
        String explicitBuilderName = this.explicitBuilderName(entry);
        BuilderDestroyerPair explicitDefaultBuilder = this.explicitDefaultBuilder(explicitBuilderName);
        if (explicitDefaultBuilder != null) {
            return entry;
        }
        if (root == entry) {
            return null;
        }
        return this.explicitDefaultBuilderEntry(root, entry.getParent());
    }

    private BuilderDestroyerPair explicitDefaultBuilder(String explicitBuilderName) {
        String subtreeDefaultBuilder = this.subtreeDefaultVisitors.get(explicitBuilderName);
        BuilderDestroyerPair explicitDefaultBuilder = this.visitors.get(subtreeDefaultBuilder);
        return explicitDefaultBuilder;
    }

    private String explicitBuilderName(Entry entry) {
        String builderToCall = null;
        if (entry != null) {
            for (String visitorName : entry.builders()) {
                if (!this.visitors.containsKey(visitorName)) continue;
                builderToCall = visitorName;
                break;
            }
        }
        return builderToCall;
    }

    public RecursiveMenuStructureProcessor forChildren(Entry root, Entry subtreeRoot) {
        return new RecursiveMenuStructureProcessor(this.visitors, this.subtreeDefaultVisitors, this.findSubtreeChildrenDefaultBuilder(root, subtreeRoot));
    }

    public boolean containsOneOf(Collection<String> builders) {
        for (String builder : builders) {
            if (!this.visitors.containsKey(builder)) continue;
            return true;
        }
        return false;
    }
}

