/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.openstreetmap.josm.gui.mappaint.DividedScale;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.tools.Pair;

public final class StyleCache {
    private static final Map<StyleCache, StyleCache> internPool = new ConcurrentHashMap<StyleCache, StyleCache>();
    public static final StyleCache EMPTY_STYLECACHE = new StyleCache().intern();
    private DividedScale<StyleElementList> plainStyle;
    private DividedScale<StyleElementList> selectedStyle;

    private StyleCache(StyleCache sc) {
        this.plainStyle = sc.plainStyle;
        this.selectedStyle = sc.selectedStyle;
    }

    private StyleCache() {
    }

    public StyleCache put(StyleElementList o, Range r, boolean selected) {
        StyleCache s = new StyleCache(this);
        if (selected) {
            s.selectedStyle = StyleCache.scale(s.selectedStyle).put(o, r);
        } else {
            s.plainStyle = StyleCache.scale(s.plainStyle).put(o, r);
        }
        return s.intern();
    }

    private static DividedScale<StyleElementList> scale(DividedScale<StyleElementList> scale) {
        return scale == null ? new DividedScale() : scale;
    }

    public Pair<StyleElementList, Range> getWithRange(double scale, boolean selected) {
        DividedScale<StyleElementList> style = selected ? this.selectedStyle : this.plainStyle;
        return style != null ? style.getWithRange(scale) : Pair.create(null, Range.ZERO_TO_INFINITY);
    }

    public String toString() {
        return "StyleCache{PLAIN: " + String.valueOf(this.plainStyle) + " SELECTED: " + String.valueOf(this.selectedStyle) + "}";
    }

    public int hashCode() {
        return 31 * Objects.hashCode(this.plainStyle) + Objects.hashCode(this.selectedStyle);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StyleCache other = (StyleCache)obj;
        return Objects.equals(this.plainStyle, other.plainStyle) && Objects.equals(this.selectedStyle, other.selectedStyle);
    }

    private StyleCache intern() {
        return internPool.computeIfAbsent(this, Function.identity());
    }

    static void clearStyleCachePool() {
        internPool.clear();
    }

    public static int getInternPoolSize() {
        return internPool.size();
    }
}

