/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Array;
import ghidra.util.datastruct.DataTable;
import java.io.Serializable;

public class LongArrayArray
implements Array,
Serializable {
    private static final long serialVersionUID = 1L;
    static final int MIN_SIZE = 4;
    long[] longs = new long[10];
    int[] starts = new int[4];
    short[] lengths = new short[4];
    int totalSpaceAllocated;
    int nextFree = 1;
    int lastStart = -1;

    public void put(int index, long[] value) {
        if (value == null) {
            this.remove(index);
            return;
        }
        if (index >= this.starts.length) {
            this.adjustArraySizes(Math.max(index + 1, this.starts.length * 2));
        }
        if (index > this.lastStart) {
            this.lastStart = index;
        }
        if (this.starts[index] > 0) {
            if (this.lengths[index] >= value.length) {
                this.totalSpaceAllocated -= this.lengths[index] - value.length;
            } else {
                this.totalSpaceAllocated -= this.lengths[index];
                this.starts[index] = this.allocSpace(value.length);
            }
        } else {
            this.starts[index] = this.allocSpace(value.length);
        }
        this.lengths[index] = (short)value.length;
        System.arraycopy(value, 0, this.longs, this.starts[index], value.length);
    }

    public long[] get(int index) {
        if (index <= this.starts.length) {
            int start = this.starts[index];
            short len = this.lengths[index];
            if (start > 0) {
                long[] ret = new long[len];
                if (len > 0) {
                    System.arraycopy(this.longs, start, ret, 0, len);
                }
                return ret;
            }
        }
        return null;
    }

    @Override
    public void remove(int index) {
        try {
            if (this.starts[index] > 0) {
                this.totalSpaceAllocated -= this.lengths[index];
                this.starts[index] = 0;
                if (this.totalSpaceAllocated < this.longs.length / 4) {
                    this.adjustSpace(this.totalSpaceAllocated * 2);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (index == this.lastStart) {
            this.findLastStart();
            if (this.lastStart < this.starts.length / 4) {
                this.shrinkArrays(this.lastStart * 2);
            }
        }
    }

    private void findLastStart() {
        for (int i = this.lastStart; i >= 0; --i) {
            if (this.starts[i] == 0) continue;
            this.lastStart = i;
            return;
        }
        this.lastStart = -1;
    }

    private void adjustArraySizes(int size) {
        if (size < 4) {
            size = 4;
        }
        int len = Math.min(size, this.starts.length);
        int[] newStarts = new int[size];
        short[] newLengths = new short[size];
        System.arraycopy(this.starts, 0, newStarts, 0, len);
        System.arraycopy(this.lengths, 0, newLengths, 0, len);
        this.starts = newStarts;
        this.lengths = newLengths;
    }

    private void shrinkArrays(int capacity) {
        int size = Math.max(capacity, 4);
        int[] newStarts = new int[size];
        short[] newLengths = new short[size];
        System.arraycopy(this.starts, 0, newStarts, 0, newStarts.length);
        System.arraycopy(this.lengths, 0, newLengths, 0, newStarts.length);
        this.starts = newStarts;
        this.lengths = newLengths;
    }

    private int allocSpace(int size) {
        if (size > this.longs.length - this.nextFree) {
            this.adjustSpace(2 * (this.totalSpaceAllocated + size));
        }
        int ret = this.nextFree;
        this.nextFree += size;
        this.totalSpaceAllocated += size;
        return ret;
    }

    private void adjustSpace(int newSize) {
        if (newSize < 10) {
            newSize = 10;
        }
        long[] newLongs = new long[newSize];
        int pos = 1;
        for (int i = 0; i < this.starts.length; ++i) {
            if (this.starts[i] <= 0) continue;
            System.arraycopy(this.longs, this.starts[i], newLongs, pos, this.lengths[i]);
            this.starts[i] = pos;
            pos += this.lengths[i];
        }
        this.nextFree = pos;
        this.longs = newLongs;
    }

    @Override
    public int getLastNonEmptyIndex() {
        return this.lastStart;
    }

    @Override
    public void copyDataTo(int index, DataTable table, int toIndex, int toCol) {
        table.putLongArray(toIndex, toCol, this.get(index));
    }
}

