/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sevenzipjbinding.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.IOutStream;
import net.sf.sevenzipjbinding.SevenZipException;

public class ByteArrayStream
implements IInStream,
IOutStream {
    private static final int INPUT_STREAM_READ_BUFFER_SIZE = 16384;
    private static final int MAX_CHUNK_SIZE = 0x100000;
    private final List<byte[]> chunkList = new ArrayList<byte[]>();
    private final int initialSize;
    private final int maxSize;
    private int currentPosition;
    private int currentPositionInChunk;
    private int currentChunkIndex;
    private int size;
    private int seekToPosition;

    public ByteArrayStream(byte[] byArray, boolean bl, int n) {
        this(1024, n);
        this.setBytes(byArray, bl);
    }

    public ByteArrayStream(byte[] byArray, boolean bl) {
        this(1024 > byArray.length ? byArray.length : 1024, byArray.length);
        this.setBytes(byArray, bl);
    }

    public ByteArrayStream(int n) {
        this(1024, n);
    }

    public ByteArrayStream(int n, int n2) {
        this.initialSize = n;
        if (n2 < 0) {
            throw new IllegalStateException("Maximal size of the byte array stream should be >0");
        }
        if (n < 0) {
            throw new IllegalStateException("Initial size of the byte array stream should be >0");
        }
        this.maxSize = n2;
        this.init();
    }

    private void init() {
        this.chunkList.clear();
        this.currentPosition = 0;
        this.currentPositionInChunk = 0;
        this.currentChunkIndex = -1;
        this.size = 0;
        this.seekToPosition = -1;
    }

    public int read(byte[] byArray) throws SevenZipException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IllegalStateException("Invalid start position (" + n + ") and length (" + n2 + ")");
        }
        if (this.seekToPosition > this.size) {
            return 0;
        }
        this.performDelayedSeek();
        for (int i = n3 = this.currentPosition + n2 > this.size ? this.size - this.currentPosition : n2; i > 0; i -= n4) {
            int n5 = this.chunkList.get(this.currentChunkIndex).length;
            int n6 = n5 - this.currentPositionInChunk;
            n4 = i > n6 ? n6 : i;
            System.arraycopy(this.chunkList.get(this.currentChunkIndex), this.currentPositionInChunk, byArray, n, n4);
            n += n4;
            this.currentPositionInChunk += n4;
            if (this.currentPositionInChunk < n5 || this.currentChunkIndex >= this.chunkList.size() - 1) continue;
            ++this.currentChunkIndex;
            this.currentPositionInChunk = 0;
            n6 = this.chunkList.get(this.currentChunkIndex).length;
        }
        this.currentPosition += n3;
        return n3;
    }

    public synchronized boolean isEOF() {
        return this.getCurrentPosition() >= this.size;
    }

    public synchronized long seek(long l, int n) throws SevenZipException {
        long l2;
        switch (n) {
            case 0: {
                l2 = l;
                break;
            }
            case 1: {
                if (this.seekToPosition == -1) {
                    l2 = (long)this.currentPosition + l;
                    break;
                }
                l2 = (long)this.seekToPosition + l;
                break;
            }
            case 2: {
                l2 = (long)this.size + l;
                break;
            }
            default: {
                throw new SevenZipException("Seek: unknown origin: " + n);
            }
        }
        if (l2 > (long)this.maxSize) {
            throw new RuntimeException("Maximal size of the byte array stream was reached by seek to " + l2 + ", maximal size is " + this.maxSize + " bytes");
        }
        this.seekToPosition = (int)l2;
        return l2;
    }

    public synchronized void rewind() {
        this.seekToPosition = 0;
    }

    public synchronized void setSize(long l) {
        this.setSize(l, false);
    }

    private synchronized void setSize(long l, boolean bl) {
        int n;
        int n2;
        int n3;
        if (l == 0L) {
            this.truncate();
            return;
        }
        if (l > (long)this.maxSize) {
            throw new RuntimeException("Maximal size of the byte array stream was reached by setSize(" + l + "). Maximal size is " + this.maxSize + " bytes");
        }
        if (l > (long)this.size) {
            if (this.size == 0) {
                this.chunkList.add(new byte[(int)l]);
                this.currentChunkIndex = 0;
                this.size = (int)l;
            }
            n3 = (int)(l - (long)this.size);
            n2 = 0;
            for (n = 0; n < this.chunkList.size(); ++n) {
                n2 += this.chunkList.get(n).length;
            }
            n = n2 - this.size;
            if (n < n3) {
                this.size += n;
                this.allocateNextChunk(n3 - n);
                if (bl) {
                    this.currentPositionInChunk = n3 - n;
                }
            } else if (bl) {
                this.currentPositionInChunk = this.chunkList.get(this.chunkList.size() - 1).length - n + n3;
            }
            if (bl) {
                this.currentChunkIndex = this.chunkList.size() - 1;
                this.currentPosition = (int)l;
            }
            this.size = (int)l;
        }
        if (l < (long)this.size) {
            n3 = 0;
            for (n2 = 0; n2 < this.chunkList.size(); ++n2) {
                if ((long)(n3 += this.chunkList.get(n2).length) < l) continue;
                for (n = this.chunkList.size() - 1; n > n2; --n) {
                    this.chunkList.remove(n);
                }
                if (this.seekToPosition != -1 && (long)this.seekToPosition > l) {
                    this.seekToPosition = (int)l;
                } else if ((long)this.currentPosition > l) {
                    this.currentPosition = (int)l;
                    this.currentPositionInChunk = this.currentPosition - n3 + this.chunkList.get(n2).length;
                    this.currentChunkIndex = n2;
                }
                this.size = (int)l;
            }
        }
    }

    public int write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    public synchronized int write(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IllegalStateException("Invalid start position (" + n + ") and length (" + n2 + ")");
        }
        if (n2 == 0) {
            return 0;
        }
        this.performDelayedSeek();
        this.startWriting();
        int n3 = n;
        int n4 = n2;
        do {
            byte[] byArray2;
            int n5;
            int n6 = (n5 = (byArray2 = this.chunkList.get(this.currentChunkIndex)).length - this.currentPositionInChunk) < n4 ? n5 : n4;
            System.arraycopy(byArray, n3, byArray2, this.currentPositionInChunk, n6);
            this.currentPositionInChunk += n6;
            this.currentPosition += n6;
            n3 += n6;
            n4 -= n6;
            if (this.currentPositionInChunk < byArray2.length) continue;
            this.currentPositionInChunk = 0;
            ++this.currentChunkIndex;
            if (this.currentChunkIndex < this.chunkList.size()) continue;
            this.allocateNextChunk(-1);
        } while (n4 > 0);
        if (this.currentPosition > this.size) {
            this.size = this.currentPosition;
        }
        this.endWriting();
        return byArray.length;
    }

    public InputStream getDetachedInputStream() {
        throw new IllegalStateException("Not implemented");
    }

    public InputStream getInputStream() {
        throw new IllegalStateException("Not implemented");
    }

    public OutputStream getOutputStream() {
        throw new IllegalStateException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeToOutputStream(OutputStream outputStream, boolean bl) throws IOException {
        try {
            int n = 0;
            for (byte[] byArray : this.chunkList) {
                int n2 = n + byArray.length > this.size ? this.size - n : byArray.length;
                outputStream.write(byArray, 0, n2);
                n += n2;
            }
        }
        finally {
            if (bl) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public synchronized void writeFromInputStream(InputStream inputStream, boolean bl) throws IOException {
        this.performDelayedSeek();
        if (this.size == 0) {
            int n;
            byte[] byArray;
            this.init();
            int n2 = inputStream.available();
            if (n2 > this.maxSize) {
                throw new RuntimeException("Maximal size of the byte array stream was reached. (Max size = " + this.maxSize + ")");
            }
            if (n2 > this.initialSize) {
                byArray = new byte[n2];
                n = inputStream.read(byArray);
                if (n == -1) {
                    return;
                }
                this.size = n;
                this.currentPosition = n;
                this.currentPositionInChunk = n;
                this.currentChunkIndex = 0;
                this.chunkList.add(byArray);
            }
            this.startWriting();
            while ((n = inputStream.read(byArray = this.chunkList.get(this.currentChunkIndex), this.currentPositionInChunk, byArray.length - this.currentPositionInChunk)) != -1) {
                this.currentPosition += n;
                this.currentPositionInChunk += n;
                if (byArray.length - this.currentPositionInChunk != 0) continue;
                this.allocateNextChunk(-1);
            }
            this.size = this.currentPosition;
            this.endWriting();
        } else {
            int n;
            byte[] byArray = new byte[16384];
            while ((n = inputStream.read(byArray)) != -1) {
                this.write(byArray, 0, n);
            }
        }
        if (bl) {
            inputStream.close();
        }
    }

    public synchronized void truncate() {
        this.init();
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized int getCurrentPosition() {
        if (this.seekToPosition != -1) {
            return this.seekToPosition;
        }
        return this.currentPosition;
    }

    public synchronized byte[] getBytes() {
        byte[] byArray = new byte[this.size];
        int n = 0;
        for (byte[] byArray2 : this.chunkList) {
            int n2 = n + byArray2.length > this.size ? this.size - n : byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n, n2);
            n += n2;
        }
        return byArray;
    }

    public synchronized void setBytes(byte[] byArray, boolean bl) {
        this.init();
        byte[] byArray2 = byArray;
        int n = byArray.length;
        if (bl) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
        }
        this.chunkList.add(byArray2);
        this.currentChunkIndex = 0;
        this.currentPosition = 0;
        this.currentPositionInChunk = 0;
        this.size = n;
    }

    private void performDelayedSeek() {
        if (this.seekToPosition == -1) {
            return;
        }
        if (this.currentPosition == this.seekToPosition) {
            this.seekToPosition = -1;
            return;
        }
        if (this.seekToPosition > this.size) {
            this.setSize(this.seekToPosition, true);
            this.seekToPosition = -1;
            return;
        }
        int n = 0;
        for (int i = 0; i < this.chunkList.size(); ++i) {
            int n2 = this.chunkList.get(i).length;
            if ((n += n2) <= this.seekToPosition) continue;
            this.currentChunkIndex = i;
            this.currentPositionInChunk = n2 - (n - this.seekToPosition);
            this.currentPosition = this.seekToPosition;
            this.seekToPosition = -1;
            return;
        }
        this.currentChunkIndex = this.chunkList.size() - 1;
        this.currentPositionInChunk = this.chunkList.get(this.currentChunkIndex).length;
        this.currentPosition = this.size;
        this.seekToPosition = -1;
    }

    private void startWriting() {
        if (this.currentChunkIndex == -1 || this.currentPositionInChunk >= this.chunkList.get(this.currentChunkIndex).length) {
            this.allocateNextChunk(-1);
        }
    }

    private void endWriting() {
        if (this.size == this.currentPosition && this.currentPositionInChunk == 0) {
            if (this.currentChunkIndex == 0) {
                this.init();
            } else {
                this.chunkList.remove(this.currentChunkIndex--);
                this.currentPositionInChunk = this.chunkList.get(this.currentChunkIndex).length;
            }
        }
    }

    private void allocateNextChunk(int n) {
        int n2;
        if (this.currentChunkIndex == -1 || this.currentChunkIndex == this.chunkList.size() - 1 && this.chunkList.get(this.currentChunkIndex).length == this.currentPositionInChunk) {
            this.currentPositionInChunk = 0;
            ++this.currentChunkIndex;
        }
        if (this.size >= this.maxSize) {
            throw new RuntimeException("Maximal size of the byte array stream was reached. (Max size = " + this.maxSize + ")");
        }
        int n3 = this.chunkList.size() - 1;
        int n4 = n2 = n3 == -1 ? this.initialSize : this.chunkList.get(n3).length << 1;
        if (n2 < 0 || n2 > 0x100000) {
            n2 = 0x100000;
        }
        if (this.size + n2 > this.maxSize) {
            n2 = this.maxSize - this.size;
        }
        if (n != -1 && n2 < n) {
            if (this.size + n >= this.maxSize) {
                throw new RuntimeException("Maximal size of the byte array stream was reached. (Max size = " + this.maxSize + ")");
            }
            n2 = n;
        }
        byte[] byArray = new byte[n2];
        this.chunkList.add(byArray);
    }

    public void close() throws IOException {
    }
}

