/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBComponentProvider;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FileSystemBrowserPlugin;
import ghidra.plugins.fsbrowser.OpenWithTarget;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class ImportFSBFileHandler
implements FSBFileHandler {
    public static final String FSB_IMPORT_SINGLE = "FSB Import Single";
    private FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder(FSB_IMPORT_SINGLE, this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getLoadableFSRL() != null).popupMenuIcon(FSBIcons.IMPORT).popupMenuPath(new String[]{"Import"}).popupMenuGroup("F", "A").onAction(ac -> {
            FSBNode node = ac.getSelectedNode();
            FSRL fsrl = node.getLoadableFSRL();
            if (fsrl == null) {
                return;
            }
            String suggestedPath = FilenameUtils.getFullPathNoEndSeparator((String)node.getFormattedTreePath()).replaceAll(":/", "/");
            FSBComponentProvider fsbComp = ac.getComponentProvider();
            FileSystemBrowserPlugin plugin = fsbComp.getPlugin();
            OpenWithTarget openWith = OpenWithTarget.getDefault(plugin.getTool());
            ac.getTree().runTask(monitor -> {
                if (!fsbComp.ensureFileAccessable(fsrl, node, monitor)) {
                    return;
                }
                ImporterUtilities.showImportSingleFileDialog(fsrl, null, suggestedPath, plugin.getTool(), openWith.getPm(), monitor);
            });
        }).build());
    }
}

