/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import ghidra.app.services.ProgramManager;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DefaultLaunchMode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.Project;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class OpenWithTarget {
    private final String name;
    private final ProgramManager pm;
    private final Icon icon;

    public static List<OpenWithTarget> getAll() {
        ArrayList<OpenWithTarget> results = new ArrayList<OpenWithTarget>();
        Project project = AppInfo.getActiveProject();
        if (project != null) {
            ToolTemplate[] templates;
            results.addAll(OpenWithTarget.getRunningTargets(project));
            ToolTemplate defaultTT = project.getToolServices().getDefaultToolTemplate("Program");
            results.add(new OpenWithTarget(defaultTT.getName(), null, defaultTT.getIcon()));
            for (ToolTemplate toolTemplate : templates = project.getLocalToolChest().getToolTemplates()) {
                if (toolTemplate.getName().equals(defaultTT.getName())) continue;
                results.add(new OpenWithTarget(toolTemplate.getName(), null, toolTemplate.getIcon()));
            }
        }
        return results;
    }

    public static OpenWithTarget getDefault(PluginTool tool) {
        List<OpenWithTarget> runningTargets;
        Project project = tool.getProject();
        if (project == null) {
            return null;
        }
        ProgramManager pm = (ProgramManager)tool.getService(ProgramManager.class);
        if (pm != null) {
            return new OpenWithTarget(tool.getName(), pm, tool.getIcon());
        }
        if (AppInfo.getFrontEndTool().getDefaultLaunchMode() == DefaultLaunchMode.REUSE_TOOL && !(runningTargets = OpenWithTarget.getRunningTargets(project)).isEmpty()) {
            return runningTargets.get(0);
        }
        ToolTemplate defaultTT = project.getToolServices().getDefaultToolTemplate("Program");
        return new OpenWithTarget(defaultTT.getName(), null, defaultTT.getIcon());
    }

    public static OpenWithTarget getRunningProgramManager(PluginTool tool) {
        Project project = tool.getProject();
        if (project == null) {
            return null;
        }
        ProgramManager pm = (ProgramManager)tool.getService(ProgramManager.class);
        if (pm != null) {
            return new OpenWithTarget(tool.getName(), pm, tool.getIcon());
        }
        List<OpenWithTarget> runningTargets = OpenWithTarget.getRunningTargets(project);
        return !runningTargets.isEmpty() ? runningTargets.get(0) : null;
    }

    public OpenWithTarget(String name, ProgramManager pm, Icon icon) {
        this.name = name;
        this.pm = pm;
        this.icon = icon;
    }

    public String getName() {
        return this.name;
    }

    public ProgramManager getPm() {
        return this.pm;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void open(List<DomainFile> files) {
        Project project = AppInfo.getActiveProject();
        if (project == null) {
            return;
        }
        if (this.pm != null) {
            this.openWithPM(files);
        } else {
            this.openWithToolTemplate(project, files);
        }
    }

    private Map<DomainFile, Program> openWithPM(List<DomainFile> files) {
        HashMap<DomainFile, Program> results = new HashMap<DomainFile, Program>();
        for (DomainFile file : files) {
            int openMode;
            Program program = this.pm.openProgram(file, -1, openMode = results.isEmpty() ? 1 : 2);
            if (program == null) continue;
            results.put(file, program);
        }
        return results;
    }

    private Map<DomainFile, Program> openWithToolTemplate(Project project, List<DomainFile> files) {
        ProgramManager newToolPM;
        HashMap<DomainFile, Program> results = new HashMap<DomainFile, Program>();
        PluginTool newTool = project.getToolServices().launchTool(this.name, files);
        if (newTool != null && (newToolPM = (ProgramManager)newTool.getService(ProgramManager.class)) != null) {
            HashSet<DomainFile> fileSet = new HashSet<DomainFile>(files);
            for (Program openProgram : newToolPM.getAllOpenPrograms()) {
                if (!fileSet.contains(openProgram.getDomainFile())) continue;
                results.put(openProgram.getDomainFile(), openProgram);
            }
        }
        return results;
    }

    private static List<OpenWithTarget> getRunningTargets(Project project) {
        ArrayList<OpenWithTarget> results = new ArrayList<OpenWithTarget>();
        for (PluginTool runningTool : project.getToolManager().getRunningTools()) {
            ProgramManager runningPM = (ProgramManager)runningTool.getService(ProgramManager.class);
            if (runningPM == null) continue;
            Program currentProgram = runningPM.getCurrentProgram();
            int programCount = runningPM.getAllOpenPrograms().length;
            Object descName = runningTool.getName();
            if (currentProgram != null) {
                descName = (String)descName + ": " + currentProgram.getName();
                if (programCount > 1) {
                    descName = (String)descName + " (+%d more)".formatted(programCount - 1);
                }
            }
            results.add(new OpenWithTarget((String)descName, runningPM, runningTool.getIcon()));
        }
        Collections.sort(results, (r1, r2) -> r2.name.compareTo(r1.name));
        return results;
    }
}

