/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.format;

import ghidra.features.base.memsearch.format.SearchFormat;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import ghidra.features.base.memsearch.matcher.InvalidByteMatcher;
import ghidra.features.base.memsearch.matcher.MaskedByteSequenceByteMatcher;
import ghidra.util.HTMLUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

class HexSearchFormat
extends SearchFormat {
    private static final String WILD_CARDS = ".?";
    private static final String VALID_CHARS = "0123456789abcdefABCDEF.?";
    private static final int MAX_GROUP_SIZE = 16;

    HexSearchFormat() {
        super("Hex");
    }

    @Override
    public ByteMatcher parse(String input, SearchSettings settings) {
        if ((input = input.trim()).isBlank()) {
            return new InvalidByteMatcher("");
        }
        List<String> byteGroups = this.getByteGroups(input);
        if (this.hasInvalidChars(byteGroups)) {
            return new InvalidByteMatcher("Invalid character");
        }
        if (this.checkGroupSize(byteGroups)) {
            return new InvalidByteMatcher("Max group size exceeded. Enter <space> to add more.");
        }
        List<String> byteList = this.getByteList(byteGroups, settings);
        byte[] bytes = this.getBytes(byteList);
        byte[] masks = this.getMask(byteList);
        return new MaskedByteSequenceByteMatcher(input, bytes, masks, settings);
    }

    @Override
    public String getToolTip() {
        return HTMLUtilities.toHTML((String)"Interpret value as a sequence of\nhex numbers, separated by spaces.\nEnter '.' or '?' for a wildcard match");
    }

    private byte[] getBytes(List<String> byteList) {
        byte[] bytes = new byte[byteList.size()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = this.getByte(byteList.get(i));
        }
        return bytes;
    }

    private byte[] getMask(List<String> byteList) {
        byte[] masks = new byte[byteList.size()];
        for (int i = 0; i < masks.length; ++i) {
            masks[i] = this.getMask(byteList.get(i));
        }
        return masks;
    }

    private byte getMask(String tok) {
        char c1 = tok.charAt(0);
        char c2 = tok.charAt(1);
        int index1 = WILD_CARDS.indexOf(c1);
        int index2 = WILD_CARDS.indexOf(c2);
        if (index1 >= 0 && index2 >= 0) {
            return 0;
        }
        if (index1 >= 0 && index2 < 0) {
            return 15;
        }
        if (index1 < 0 && index2 >= 0) {
            return -16;
        }
        return -1;
    }

    private byte getByte(String tok) {
        char c1 = tok.charAt(0);
        char c2 = tok.charAt(1);
        return (byte)(this.hexValueOf(c1) * 16 + this.hexValueOf(c2));
    }

    private List<String> getByteList(List<String> byteGroups, SearchSettings settings) {
        ArrayList<String> byteList = new ArrayList<String>();
        for (String byteGroup : byteGroups) {
            List<String> byteStrings = this.getByteStrings(byteGroup);
            if (!settings.isBigEndian()) {
                Collections.reverse(byteStrings);
            }
            byteList.addAll(byteStrings);
        }
        return byteList;
    }

    private List<String> getByteStrings(String token) {
        if (this.isSingleWildCardChar((String)token)) {
            token = (String)token + (String)token;
        } else if (((String)token).length() % 2 != 0) {
            token = "0" + (String)token;
        }
        int n = ((String)token).length() / 2;
        ArrayList<String> list = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            list.add(((String)token).substring(i * 2, i * 2 + 2));
        }
        return list;
    }

    private boolean isSingleWildCardChar(String token) {
        if (token.length() == 1) {
            char c = token.charAt(0);
            return WILD_CARDS.indexOf(c) >= 0;
        }
        return false;
    }

    private boolean hasInvalidChars(List<String> byteGroups) {
        for (String byteGroup : byteGroups) {
            if (!this.hasInvalidChars(byteGroup)) continue;
            return true;
        }
        return false;
    }

    private boolean checkGroupSize(List<String> byteGroups) {
        for (String byteGroup : byteGroups) {
            if (byteGroup.length() <= 16) continue;
            return true;
        }
        return false;
    }

    private List<String> getByteGroups(String input) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(input);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    private boolean hasInvalidChars(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (VALID_CHARS.indexOf(string.charAt(i)) >= 0) continue;
            return true;
        }
        return false;
    }

    private int hexValueOf(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }

    @Override
    public String convertText(String text, SearchSettings oldSettings, SearchSettings newSettings) {
        ByteMatcher byteMatcher;
        SearchFormat oldFormat = oldSettings.getSearchFormat();
        if (oldFormat.getClass() == this.getClass()) {
            return text;
        }
        if (oldFormat.getFormatType() != SearchFormat.SearchFormatType.STRING_TYPE && (byteMatcher = oldFormat.parse(text, oldSettings)) instanceof MaskedByteSequenceByteMatcher) {
            MaskedByteSequenceByteMatcher matcher = (MaskedByteSequenceByteMatcher)byteMatcher;
            byte[] bytes = matcher.getBytes();
            byte[] mask = matcher.getMask();
            return this.getMaskedInputString(bytes, mask);
        }
        return this.isValidText(text, newSettings) ? text : "";
    }

    private String getMaskedInputString(byte[] bytes, byte[] mask) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String s = String.format("%02x", bytes[i]);
            builder.append((mask[i] & 0xF0) == 0 ? "." : Character.valueOf(s.charAt(0)));
            builder.append((mask[i] & 0xF) == 0 ? "." : Character.valueOf(s.charAt(1)));
            builder.append(" ");
        }
        return builder.toString().trim();
    }

    @Override
    public SearchFormat.SearchFormatType getFormatType() {
        return SearchFormat.SearchFormatType.BYTE;
    }
}

