/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.demangler.DemangledDataType;
import ghidra.program.model.data.DataType;
import java.util.ArrayList;
import java.util.List;

public class DemangledTemplate {
    private List<DemangledDataType> parameters = new ArrayList<DemangledDataType>();

    public void addParameter(DemangledDataType parameter) {
        this.parameters.add(parameter);
    }

    public List<DemangledDataType> getParameters() {
        return new ArrayList<DemangledDataType>(this.parameters);
    }

    public String toTemplate() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('<');
        for (int i = 0; i < this.parameters.size(); ++i) {
            buffer.append(this.parameters.get(i).getSignature());
            if (i >= this.parameters.size() - 1) continue;
            buffer.append(',');
        }
        buffer.append('>');
        return buffer.toString();
    }

    public String toString() {
        return this.toTemplate();
    }

    public DataType getDataType(int defaultPointerSize) {
        throw new UnsupportedOperationException("We cannot store templated types in the datatype manager!");
    }
}

