/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.prelink;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.prelink.MachoPrelinkMap;
import ghidra.app.util.bin.format.macho.prelink.NoPreLinkSectionException;
import ghidra.util.NumericUtilities;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class MachoPrelinkParser {
    private static final String TAG_DATA = "data";
    private static final String TAG_FALSE = "false";
    private static final String TAG_TRUE = "true";
    private static final String TAG_INTEGER = "integer";
    private static final String TAG_STRING = "string";
    private static final String TAG_KEY = "key";
    private static final String TAG_DICT = "dict";
    private static final String TAG_ARRAY = "array";
    private Map<String, String> idToStrings = new HashMap<String, String>();
    private Map<String, Long> idToIntegers = new HashMap<String, Long>();
    private MachHeader mainHeader;
    private ByteProvider provider;

    public MachoPrelinkParser(MachHeader mainHeader, ByteProvider provider) {
        this.mainHeader = mainHeader;
        this.provider = provider;
    }

    public List<MachoPrelinkMap> parse(TaskMonitor monitor) throws IOException, JDOMException, NoPreLinkSectionException {
        InputStream inputStream = this.findPrelinkInputStream();
        monitor.setMessage("Parsing prelink plist...");
        SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
        Document doc = sax.build(inputStream);
        Element root = doc.getRootElement();
        ArrayList<MachoPrelinkMap> list = new ArrayList<MachoPrelinkMap>();
        if (root.getName().equals(TAG_ARRAY)) {
            this.process(root.getChildren(), list, monitor);
        } else {
            Iterator iterator = root.getChildren().iterator();
            while (iterator.hasNext() && !monitor.isCancelled()) {
                Element element = (Element)iterator.next();
                if (element.getName().equals(TAG_DICT)) {
                    this.processTopDict(monitor, list, element);
                    continue;
                }
                if (!element.getName().equals(TAG_KEY)) continue;
                this.processKey(monitor, list, iterator, element);
            }
        }
        return list;
    }

    private void processTopDict(TaskMonitor monitor, List<MachoPrelinkMap> list, Element dictRootElement) {
        Iterator iterator = dictRootElement.getChildren().iterator();
        while (iterator.hasNext() && !monitor.isCancelled()) {
            Element element = (Element)iterator.next();
            if (!element.getName().equals(TAG_KEY)) continue;
            this.processKey(monitor, list, iterator, element);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processKey(TaskMonitor monitor, List<MachoPrelinkMap> list, Iterator<?> iterator, Element element) {
        String value = element.getValue();
        if (value.equals("_PrelinkPersonalities")) {
            Element arrayElement = (Element)iterator.next();
            if (arrayElement.getChildren().size() != 0) return;
        }
        if (!value.equals("_PrelinkInfoDictionary")) return;
        Element arrayElement = (Element)iterator.next();
        this.process(arrayElement.getChildren(), list, monitor);
    }

    private void process(List<?> children, List<MachoPrelinkMap> list, TaskMonitor monitor) {
        monitor.setMessage("Processing prelink information...");
        for (int i = 0; i < children.size() && !monitor.isCancelled(); ++i) {
            Element element = (Element)children.get(i);
            if (!element.getName().equals(TAG_DICT)) continue;
            MachoPrelinkMap map = this.processElement(element, monitor);
            list.add(map);
        }
    }

    private MachoPrelinkMap processElement(Element parentElement, TaskMonitor monitor) {
        MachoPrelinkMap map = new MachoPrelinkMap();
        Iterator iterator = parentElement.getChildren().iterator();
        while (iterator.hasNext() && !monitor.isCancelled()) {
            Element element = (Element)iterator.next();
            if (!element.getName().equals(TAG_KEY)) continue;
            Element valueElement = (Element)iterator.next();
            this.processValue(element, valueElement, map, monitor);
        }
        return map;
    }

    private String processValue(Element keyElement, Element valueElement, MachoPrelinkMap map, TaskMonitor monitor) {
        String key = keyElement.getValue();
        if (valueElement.getName().equals(TAG_STRING)) {
            return this.processString(map, key, valueElement);
        }
        if (valueElement.getName().equals(TAG_INTEGER)) {
            return this.processInteger(map, key, valueElement);
        }
        if (valueElement.getName().equals(TAG_TRUE)) {
            map.put(key, true);
            return TAG_TRUE;
        }
        if (valueElement.getName().equals(TAG_FALSE)) {
            map.put(key, false);
            return TAG_FALSE;
        }
        if (valueElement.getName().equals(TAG_DATA)) {
            map.put(key, valueElement.getValue());
            return valueElement.getValue();
        }
        if (valueElement.getName().equals(TAG_DICT)) {
            MachoPrelinkMap dictMap = this.processElement(valueElement, monitor);
            map.put(key, dictMap);
            return dictMap.toString();
        }
        if (valueElement.getName().equals(TAG_ARRAY)) {
            String arrayString = this.processArray(valueElement, map, monitor);
            map.put(key, arrayString);
            return arrayString;
        }
        System.out.println("Unhandled value type: " + valueElement.getName());
        return valueElement.getValue();
    }

    private String processString(MachoPrelinkMap map, String key, Element valueElement) {
        String value = valueElement.getValue();
        String id = valueElement.getAttributeValue("ID");
        String idref = valueElement.getAttributeValue("IDREF");
        if (id != null) {
            this.idToStrings.put(id, value);
        }
        if (value != null) {
            map.put(key, valueElement.getValue());
        }
        if (idref != null) {
            map.put(key, this.idToStrings.get(idref));
        }
        return value;
    }

    private String processInteger(MachoPrelinkMap map, String key, Element valueElement) {
        String value = valueElement.getValue();
        String id = valueElement.getAttributeValue("ID");
        String idref = valueElement.getAttributeValue("IDREF");
        long numericValue = -1L;
        try {
            numericValue = NumericUtilities.parseHexLong((String)value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            this.idToIntegers.put(id, numericValue);
        }
        map.put(key, numericValue);
        if (idref != null) {
            map.put(key, this.idToIntegers.get(idref));
        }
        return value;
    }

    private String processArray(Element arrayElement, MachoPrelinkMap map, TaskMonitor monitor) {
        if (!arrayElement.getName().equals(TAG_ARRAY)) {
            throw new RuntimeException("not an array element");
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = arrayElement.getChildren().iterator();
        while (iterator.hasNext() && !monitor.isCancelled()) {
            Element arrayChildElement = (Element)iterator.next();
            this.processElement(arrayChildElement, monitor);
            String value = this.processValue(arrayElement, arrayChildElement, map, monitor);
            buffer.append(value);
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        return buffer.toString();
    }

    private InputStream findPrelinkInputStream() throws IOException, NoPreLinkSectionException {
        ByteArrayInputStream prelinkInputStream = null;
        List<SegmentCommand> segments = this.mainHeader.getLoadCommands(SegmentCommand.class);
        for (SegmentCommand segment : segments) {
            int endOfDoctype;
            int doctypeIndex;
            Section section;
            if (!segment.getSegmentName().equals("__PRELINK") && !segment.getSegmentName().equals("__PRELINK_INFO") || (section = segment.getSectionByName("__info")) == null || section.getSize() <= 0L) continue;
            byte[] bytes = this.provider.readBytes(section.getOffset(), section.getSize() - 1L);
            String string = new String(bytes);
            Object trimmed = string.trim();
            if (((String)trimmed).endsWith("</>Apple")) {
                trimmed = ((String)trimmed).substring(0, ((String)trimmed).length() - 8) + "</array>";
            }
            if (((String)trimmed).endsWith("</4.2</shoneOS<")) {
                trimmed = ((String)trimmed).substring(0, ((String)trimmed).length() - 15) + "</array></dict>";
            }
            if ((doctypeIndex = ((String)trimmed).indexOf("<!DOCTYPE")) >= 0 && (endOfDoctype = ((String)trimmed).indexOf(62, doctypeIndex)) >= 0) {
                trimmed = ((String)trimmed).substring(0, doctypeIndex) + ((String)trimmed).substring(endOfDoctype + 1);
            }
            prelinkInputStream = new ByteArrayInputStream(((String)trimmed).getBytes());
        }
        if (prelinkInputStream == null) {
            throw new NoPreLinkSectionException("Unable to locate __info section in __PRELINK segment inside mach-o header for COMPLZSS file system.");
        }
        return prelinkInputStream;
    }
}

