/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.app.util.bin.format.coff.CoffSymbolAux;
import ghidra.app.util.bin.format.coff.CoffSymbolAuxFactory;
import ghidra.app.util.bin.format.coff.CoffSymbolAuxSection;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CoffSymbol
implements StructConverter {
    private String e_name;
    private int e_value;
    private short e_scnum;
    private short e_type;
    private byte e_sclass;
    private byte e_numaux;
    private List<CoffSymbolAux> _auxiliarySymbols = new ArrayList<CoffSymbolAux>();

    CoffSymbol(BinaryReader reader, CoffFileHeader header) throws IOException {
        if (reader.peekNextInt() == 0) {
            reader.readNextInt();
            int nameIndex = reader.readNextInt();
            int stringTableIndex = header.getSymbolTablePointer() + header.getSymbolTableEntries() * 18;
            this.e_name = reader.readAsciiString(stringTableIndex + nameIndex);
        } else {
            this.e_name = reader.readNextAsciiString(8);
        }
        this.e_value = reader.readNextInt();
        this.e_scnum = reader.readNextShort();
        this.e_type = reader.readNextShort();
        this.e_sclass = reader.readNextByte();
        this.e_numaux = reader.readNextByte();
        for (int i = 0; i < this.e_numaux; ++i) {
            this._auxiliarySymbols.add(CoffSymbolAuxFactory.read(reader, this));
        }
    }

    public String getName() {
        return this.e_name;
    }

    public long getValue() {
        return (long)this.e_value & 0xFFFFFFFFL;
    }

    public void move(int offset) {
        this.e_value += offset;
    }

    public short getSectionNumber() {
        return this.e_scnum;
    }

    public int getBasicType() {
        return this.e_type & 0xF;
    }

    public int getDerivedType(int derivedIndex) {
        if (derivedIndex < 1 || derivedIndex > 6) {
            throw new RuntimeException("1 <= derivedIndex <= 6");
        }
        int derivedType = (this.e_type & 0xFFFF) >> 4;
        if (derivedIndex > 1) {
            derivedType >>= derivedIndex * 2;
        }
        return derivedType & 3;
    }

    public byte getStorageClass() {
        return this.e_sclass;
    }

    public byte getAuxiliaryCount() {
        return this.e_numaux;
    }

    public List<CoffSymbolAux> getAuxiliarySymbols() {
        return new ArrayList<CoffSymbolAux>(this._auxiliarySymbols);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(StructConverterUtil.parseName(this.getClass()), 0);
        struct.add((DataType)new ArrayDataType(ASCII, 8, ASCII.getLength()), "e_name", null);
        struct.add(DWORD, "e_value", null);
        struct.add(WORD, "e_scnum", null);
        struct.add(WORD, "e_type", null);
        struct.add(BYTE, "e_sclass", null);
        struct.add(BYTE, "e_numaux", null);
        return struct;
    }

    public boolean isSection() {
        if (this.e_type == 0 && this.e_value == 0 && this.e_sclass == 3) {
            for (CoffSymbolAux aux : this._auxiliarySymbols) {
                if (!(aux instanceof CoffSymbolAuxSection)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(' ');
        buffer.append("Value=0x" + Long.toHexString(this.getValue()));
        buffer.append(' ');
        buffer.append(this.e_scnum);
        buffer.append(' ');
        buffer.append(this.e_type);
        buffer.append(' ');
        buffer.append(this.e_sclass);
        return buffer.toString();
    }
}

