/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.label;

import ghidra.app.cmd.label.CreateNamespacesCmd;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RenameLabelCmd
implements Command<Program> {
    private Address addr;
    private String oldName;
    private String newName;
    private Symbol existingSymbol;
    private Namespace currentNamespace;
    private Namespace newNamespace;
    private SourceType source;
    private String errorMessage = "";

    public RenameLabelCmd(Address addr, String oldName, String newName, SourceType source) {
        this(addr, oldName, newName, null, null, source);
    }

    public RenameLabelCmd(Symbol symbol, String newName, SourceType source) {
        this(symbol, newName, symbol.getParentNamespace(), source);
    }

    public RenameLabelCmd(Symbol symbol, String newName, Namespace newNamespace, SourceType source) {
        this.existingSymbol = Objects.requireNonNull(symbol);
        this.addr = symbol.getAddress();
        this.oldName = symbol.getName();
        this.newName = newName;
        this.currentNamespace = symbol.getParentNamespace();
        this.newNamespace = newNamespace;
        this.source = source;
    }

    private RenameLabelCmd(Address addr, String oldName, String newName, Namespace currentNamespace, Namespace newNamespace, SourceType source) {
        this.addr = addr;
        this.oldName = oldName;
        this.newName = newName;
        this.currentNamespace = currentNamespace;
        this.newNamespace = newNamespace;
        this.source = source;
    }

    public String getName() {
        return "Rename Label";
    }

    public String getStatusMsg() {
        return this.errorMessage;
    }

    public boolean applyTo(Program program) {
        if (this.currentNamespace == null) {
            this.currentNamespace = program.getGlobalNamespace();
        }
        if (this.newNamespace == null) {
            this.newNamespace = program.getGlobalNamespace();
        }
        if (!this.parseNameAndNamespace(program, this.newNamespace, this.newName)) {
            return false;
        }
        Symbol s = this.getSymbol(program);
        if (s == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.newName) && s.getSource() != SourceType.DEFAULT) {
            this.errorMessage = "Cannot set non-default symbol name to \"\"";
            return false;
        }
        try {
            if (!this.currentNamespace.equals((Object)this.newNamespace)) {
                s.setNameAndNamespace(this.newName, this.newNamespace, this.source);
            } else {
                s.setName(this.newName, this.source);
                if (!this.newName.equals(s.getName())) {
                    this.errorMessage = "Rename failed";
                    return false;
                }
            }
            return true;
        }
        catch (DuplicateNameException e) {
            this.errorMessage = "Symbol already exists: " + this.newName;
        }
        catch (InvalidInputException e) {
            this.errorMessage = "Invalid entry: " + e.getMessage();
        }
        catch (CircularDependencyException e) {
            this.errorMessage = e.getMessage();
        }
        return false;
    }

    private boolean parseNameAndNamespace(Program program, Namespace rootNamespace, String name) {
        SymbolPath symbolPath = this.getSymbolPath(name);
        if (symbolPath == null) {
            return false;
        }
        Namespace parent = this.getOrCreateNamespaces(program, symbolPath, rootNamespace);
        if (parent == null) {
            return false;
        }
        this.newNamespace = parent;
        this.newName = symbolPath.getName();
        return true;
    }

    private Symbol getSymbol(Program program) {
        if (this.existingSymbol != null) {
            return this.existingSymbol;
        }
        SymbolTable st = program.getSymbolTable();
        Symbol s = null;
        if (this.oldName != null) {
            s = st.getSymbol(this.oldName, this.addr, this.currentNamespace);
        } else {
            s = st.getPrimarySymbol(this.addr);
            if (s != null && !s.isDynamic()) {
                this.errorMessage = "Must specify name of symbol to be renamed";
                return null;
            }
        }
        if (s == null) {
            this.errorMessage = "Symbol not found: " + this.oldName;
            return null;
        }
        return s;
    }

    private Namespace getOrCreateNamespaces(Program program, SymbolPath symbolPath, Namespace rootNamespace) {
        Namespace functionNamespace;
        SymbolPath parentPath = symbolPath.getParent();
        if (parentPath == null) {
            return rootNamespace;
        }
        SymbolPath fullPath = new SymbolPath(rootNamespace.getSymbol()).append(parentPath);
        Namespace nonFunctionNs = NamespaceUtils.getNonFunctionNamespace((Program)program, (SymbolPath)fullPath);
        if (nonFunctionNs != null) {
            return nonFunctionNs;
        }
        String name = symbolPath.getName();
        if (!parentPath.containsPathEntry(name) && (functionNamespace = NamespaceUtils.getFunctionNamespaceContaining((Program)program, (SymbolPath)parentPath, (Address)this.addr)) != null) {
            return functionNamespace;
        }
        CreateNamespacesCmd cmd = new CreateNamespacesCmd(parentPath.getPath(), rootNamespace, SourceType.USER_DEFINED);
        if (cmd.applyTo(program)) {
            return cmd.getNamespace();
        }
        this.errorMessage = cmd.getStatusMsg();
        return null;
    }

    private SymbolPath getSymbolPath(String symbolName) {
        if (StringUtils.isBlank((CharSequence)symbolName)) {
            this.errorMessage = "Name cannot be blank";
            return null;
        }
        return new SymbolPath(symbolName);
    }
}

