/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.memory;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.program.TraceProgramView;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class TraceMemorySpaceInputStream
extends InputStream {
    private final TraceProgramView program;
    private final TraceMemorySpace space;
    private final Address start;
    private final Address end;
    private long mark = -1L;
    private long pos;

    public TraceMemorySpaceInputStream(TraceProgramView program, TraceMemorySpace space, AddressRange range) {
        this.program = program;
        this.space = space;
        this.start = range.getMinAddress();
        this.end = range.getMaxAddress();
    }

    @Override
    public int read() throws IOException {
        if (this.available() <= 0) {
            return -1;
        }
        ByteBuffer buf = ByteBuffer.allocate(1);
        try {
            if (this.space.getBytes(this.program.getSnap(), this.start.addNoWrap(this.pos), buf) == 0) {
                return -1;
            }
            ++this.pos;
            return buf.get(0) & 0xFF;
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(b, off, len);
        buf.limit(Math.min(this.available(), len));
        try {
            return this.space.getBytes(this.program.getSnap(), this.start.addNoWrap(this.pos), buf);
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(Math.max(0L, this.end.subtract(this.start) - this.pos + 1L), Integer.MAX_VALUE);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == -1L) {
            throw new IOException();
        }
        this.pos = this.mark;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long skipped = Math.min((long)this.available(), n);
        this.pos += skipped;
        return skipped;
    }
}

