/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.data.EditDataFieldDialog;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;

public class EditFieldAction
extends AbstractDecompilerAction {
    public EditFieldAction() {
        super("Quick Edit Field", KeyBindingType.SHARED);
        this.setHelpLocation(new HelpLocation("DataPlugin", "Edit_Field_Dialog"));
        this.setPopupMenuData(new MenuData(new String[]{"Quick Edit Field..."}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData("ctrl shift E"));
    }

    @Override
    public boolean isValidContext(ActionContext context) {
        return context instanceof DecompilerActionContext;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function instanceof UndefinedFunction) {
            return false;
        }
        Address address = context.getAddress();
        if (address == null) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (!(tokenAtCursor instanceof ClangFieldToken)) {
            return false;
        }
        Composite composite = EditFieldAction.getCompositeDataType(tokenAtCursor);
        if (composite == null) {
            return false;
        }
        int offset = ((ClangFieldToken)tokenAtCursor).getOffset();
        return offset >= 0 && offset < composite.getLength();
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        Composite composite = EditFieldAction.getCompositeDataType(tokenAtCursor);
        ClangFieldToken token = (ClangFieldToken)tokenAtCursor;
        DataTypeComponent dtc = null;
        int offset = token.getOffset();
        String fieldName = token.getText();
        if (composite instanceof Structure) {
            Structure structure = (Structure)composite;
            dtc = structure.getComponentContaining(offset);
        } else if (composite instanceof Union) {
            Union union = (Union)composite;
            int n = union.getNumComponents();
            for (int i = 0; i < n; ++i) {
                DataTypeComponent unionDtc = union.getComponent(i);
                String dtcName = unionDtc.getFieldName();
                if (!fieldName.equals(dtcName)) continue;
                dtc = unionDtc;
                break;
            }
        }
        if (dtc == null) {
            Msg.debug((Object)((Object)this), (Object)"Unable to find field '%s' at offset %d in composite %s".formatted(fieldName, offset, composite.getName()));
            return;
        }
        Address address = context.getAddress();
        Program program = context.getProgram();
        int ordinal = dtc.getOrdinal();
        PluginTool tool = context.getTool();
        DataTypeManagerService service = (DataTypeManagerService)tool.getService(DataTypeManagerService.class);
        EditDataFieldDialog dialog = new EditDataFieldDialog(tool, service, composite, program, address, ordinal);
        tool.showDialog((DialogComponentProvider)dialog);
    }
}

