/*
 * Decompiled with CFR 0.152.
 */
package generic.theme.laf;

import generic.theme.ApplicationThemeManager;
import generic.theme.GThemeValueMap;
import generic.theme.LafType;
import generic.theme.laf.CustomNimbusLookAndFeel;
import generic.theme.laf.LookAndFeelManager;
import generic.theme.laf.NimbusUiDefaultsMapper;
import generic.theme.laf.UiDefaultsMapper;
import ghidra.util.exception.AssertException;
import java.awt.Dimension;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class NimbusLookAndFeelManager
extends LookAndFeelManager {
    public NimbusLookAndFeelManager(ApplicationThemeManager themeManager) {
        super(LafType.NIMBUS, themeManager);
    }

    @Override
    public void resetAll(GThemeValueMap javaDefaults) {
        this.themeManager.refreshGThemeValues();
        this.reinstallNimubus();
    }

    @Override
    public void fontsChanged(Set<String> affectedJavaIds) {
        if (!affectedJavaIds.isEmpty()) {
            this.reinstallNimubus();
        }
        this.updateAllRegisteredComponentFonts();
        this.repaintAll();
    }

    @Override
    public void iconsChanged(Set<String> affectedJavaIds, Icon newIcon) {
        if (!affectedJavaIds.isEmpty()) {
            this.reinstallNimubus();
        }
        this.themeManager.refreshGThemeValues();
        this.repaintAll();
    }

    private void reinstallNimubus() {
        try {
            UIManager.setLookAndFeel(new CustomNimbusLookAndFeel(this.themeManager){

                @Override
                protected void installJavaDefaultsIntoThemeManager(UiDefaultsMapper uiDefaultsMapper) {
                }
            });
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new AssertException("This can't happen, we are just re-installing the same L&F");
        }
        this.updateComponentUis();
    }

    @Override
    protected void doInstallLookAndFeel() throws UnsupportedLookAndFeelException {
        CustomNimbusLookAndFeel nimbusLookAndFeel = new CustomNimbusLookAndFeel(this.themeManager);
        UIManager.setLookAndFeel(nimbusLookAndFeel);
        this.normalizedIdToLafIdMap = nimbusLookAndFeel.getNormalizedIdToLafIdMap();
    }

    @Override
    protected void processJavaDefaults() {
    }

    @Override
    protected void fixupLookAndFeelIssues() {
        super.fixupLookAndFeelIssues();
        UIDefaults uiDefaults = UIManager.getDefaults();
        uiDefaults.put("ScrollBar.minimumThumbSize", new Dimension(30, 30));
    }

    @Override
    protected UiDefaultsMapper createUiDefaultsMapper(UIDefaults defaults) {
        return new NimbusUiDefaultsMapper(defaults);
    }
}

