/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.util.LanguageTranslator;
import ghidra.program.util.RangeMapAdapter;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;

public class RegisterValueStore {
    private Register baseRegister;
    private RangeMapAdapter rangeMap;
    private boolean rangeWriteCacheEnabled = false;
    private RegisterValue rangeWriteCacheValue;
    private Address rangeWriteCacheMin;
    private Address rangeWriteCacheMax;

    public RegisterValueStore(Register register, RangeMapAdapter rangeMap, boolean enableRangeWriteCache) {
        this.baseRegister = register.getBaseRegister();
        this.rangeMap = rangeMap;
        this.rangeWriteCacheEnabled = enableRangeWriteCache;
    }

    void flushWriteCache() {
        if (this.rangeWriteCacheValue == null) {
            return;
        }
        this.doSetValue(this.rangeWriteCacheMin, this.rangeWriteCacheMax, this.rangeWriteCacheValue);
        this.rangeWriteCacheValue = null;
    }

    void invalidateWriteCache() {
        this.rangeWriteCacheValue = null;
    }

    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        this.flushWriteCache();
        this.rangeMap.moveAddressRange(fromAddr, toAddr, length, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Address start, Address end, RegisterValue newValue) {
        if (this.rangeWriteCacheEnabled) {
            if (this.rangeWriteCacheValue != null) {
                try {
                    Address nextAddrInRange = this.rangeWriteCacheMax.addNoWrap(1L);
                    if (start.equals(nextAddrInRange) && newValue.equals(this.rangeWriteCacheValue)) {
                        this.rangeWriteCacheMax = end;
                        return;
                    }
                }
                catch (AddressOverflowException addressOverflowException) {
                    // empty catch block
                }
                this.flushWriteCache();
            } else {
                this.rangeMap.checkWritableState();
            }
            RegisterValueStore registerValueStore = this;
            synchronized (registerValueStore) {
                this.rangeWriteCacheValue = newValue;
                this.rangeWriteCacheMin = start;
                this.rangeWriteCacheMax = end;
            }
            return;
        }
        this.doSetValue(start, end, newValue);
    }

    private void doSetValue(Address start, Address end, RegisterValue newValue) {
        if (!start.hasSameAddressSpace(end)) {
            throw new IllegalArgumentException("Start and end addresses must be in the same address space.");
        }
        if (newValue.getRegister().isBaseRegister() && newValue.hasValue()) {
            this.rangeMap.set(start, end, newValue.toBytes());
            return;
        }
        ArrayList<AddressRange> list = new ArrayList<AddressRange>();
        AddressRangeIterator rangeIt = this.rangeMap.getAddressRangeIterator(start, end);
        while (rangeIt.hasNext()) {
            list.add((AddressRange)rangeIt.next());
        }
        for (AddressRange indexRange : list) {
            Address rangeStart = indexRange.getMinAddress();
            Address rangeEnd = indexRange.getMaxAddress();
            if (rangeStart.compareTo(start) > 0) {
                this.rangeMap.set(start, rangeStart.previous(), newValue.toBytes());
            }
            byte[] currentBytes = this.rangeMap.getValue(rangeStart);
            RegisterValue currentValue = new RegisterValue(this.baseRegister, currentBytes);
            RegisterValue combinedValue = currentValue.combineValues(newValue);
            this.rangeMap.set(rangeStart, rangeEnd, combinedValue.toBytes());
            try {
                start = rangeEnd.addNoWrap(1L);
            }
            catch (AddressOverflowException e) {
                return;
            }
        }
        if (start != null && start.compareTo(end) <= 0) {
            this.rangeMap.set(start, end, newValue.toBytes());
        }
    }

    public void clearAll() {
        this.rangeWriteCacheValue = null;
        this.rangeMap.clearAll();
    }

    public void clearValue(Address start, Address end, Register register) {
        AddressRange.checkValidRange(start, end);
        this.flushWriteCache();
        if (register == null || register.isBaseRegister()) {
            this.rangeMap.clearRange(start, end);
            return;
        }
        ArrayList<AddressRange> list = new ArrayList<AddressRange>();
        AddressRangeIterator rangeIt = this.rangeMap.getAddressRangeIterator(start, end);
        while (rangeIt.hasNext()) {
            list.add((AddressRange)rangeIt.next());
        }
        for (AddressRange indexRange : list) {
            Address rangeStart = indexRange.getMinAddress();
            Address rangeEnd = indexRange.getMaxAddress();
            byte[] mask = register.getBaseMask();
            RegisterValue currentBaseValue = new RegisterValue(register.getBaseRegister(), this.rangeMap.getValue(rangeStart));
            RegisterValue newBaseValue = currentBaseValue.clearBitValues(mask);
            if (!newBaseValue.hasAnyValue()) {
                this.rangeMap.clearRange(rangeStart, rangeEnd);
            } else {
                this.rangeMap.set(rangeStart, rangeEnd, newBaseValue.toBytes());
            }
            start = rangeEnd.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterValue getValue(Register register, Address address) {
        RegisterValue value = null;
        byte[] bytes = this.rangeMap.getValue(address);
        if (bytes != null) {
            value = new RegisterValue(register, bytes);
        }
        RegisterValueStore registerValueStore = this;
        synchronized (registerValueStore) {
            if (this.rangeWriteCacheValue != null && address.compareTo(this.rangeWriteCacheMin) >= 0 && address.compareTo(this.rangeWriteCacheMax) <= 0) {
                value = value != null ? value.combineValues(this.rangeWriteCacheValue) : this.rangeWriteCacheValue;
                return value.getRegisterValue(register);
            }
        }
        return value;
    }

    public AddressRangeIterator getAddressRangeIterator(Address startAddress, Address endAddress) {
        this.flushWriteCache();
        return this.rangeMap.getAddressRangeIterator(startAddress, endAddress);
    }

    public AddressRangeIterator getAddressRangeIterator() {
        this.flushWriteCache();
        return this.rangeMap.getAddressRangeIterator();
    }

    public boolean isEmpty() {
        return this.rangeWriteCacheValue == null && this.rangeMap.isEmpty();
    }

    public boolean setLanguage(LanguageTranslator translator, TaskMonitor monitor) throws CancelledException {
        Register newReg = translator.getNewRegister(this.baseRegister);
        if (newReg == null) {
            return false;
        }
        this.flushWriteCache();
        if (newReg.isProcessorContext() || !newReg.isBaseRegister() || !newReg.getName().equals(this.baseRegister.getName()) || newReg.getBitLength() != this.baseRegister.getBitLength()) {
            this.rangeMap.setLanguage(translator, this.baseRegister, monitor);
            this.baseRegister = newReg.getBaseRegister();
        }
        return true;
    }

    public AddressRange getValueRangeContaining(Address addr) {
        this.flushWriteCache();
        return this.rangeMap.getValueRangeContaining(addr);
    }

    public void invalidate() {
        this.rangeMap.invalidate();
    }
}

