/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetCollection;
import ghidra.program.model.address.AddressSetView;

public class SingleAddressSetCollection
implements AddressSetCollection {
    private AddressSetView set;

    public SingleAddressSetCollection(AddressSetView set) {
        this.set = set == null ? new AddressSet() : set;
    }

    @Override
    public boolean intersects(AddressSetView addrSet) {
        return this.set.intersects(addrSet);
    }

    @Override
    public boolean intersects(Address start, Address end) {
        return this.set.intersects(start, end);
    }

    @Override
    public boolean contains(Address address) {
        return this.set.contains(address);
    }

    @Override
    public boolean hasFewerRangesThan(int rangeThreshold) {
        return this.set.getNumAddressRanges() < rangeThreshold;
    }

    @Override
    public AddressSet getCombinedAddressSet() {
        return new AddressSet(this.set);
    }

    @Override
    public Address findFirstAddressInCommon(AddressSetView otherSet) {
        return this.set.findFirstAddressInCommon(otherSet);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Address getMinAddress() {
        return this.set.getMinAddress();
    }

    @Override
    public Address getMaxAddress() {
        return this.set.getMaxAddress();
    }
}

