/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.RecursiveDescentSolver;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyTreeResolver;
import ghidra.app.plugin.processors.sleigh.ConstructState;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.ContextOp;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;

public class DefaultAssemblyResolvedPatterns
extends AbstractAssemblyResolution
implements AssemblyResolvedPatterns {
    protected static final String INS = "ins:";
    protected static final String CTX = "ctx:";
    protected static final String SEP = ",";
    protected final Constructor cons;
    protected final AssemblyPatternBlock ins;
    protected final AssemblyPatternBlock ctx;
    protected final Set<AssemblyResolvedBackfill> backfills;
    protected final Set<AssemblyResolvedPatterns> forbids;
    protected static final Pattern pat = Pattern.compile("line(\\d*)");

    protected DefaultAssemblyResolvedPatterns(AbstractAssemblyResolutionFactory<?, ?> factory, String description, Constructor cons, List<? extends AssemblyResolution> children, AssemblyResolution right, AssemblyPatternBlock ins, AssemblyPatternBlock ctx, Set<AssemblyResolvedBackfill> backfills, Set<AssemblyResolvedPatterns> forbids) {
        super(factory, description, children, right);
        this.cons = cons;
        this.ins = ins == null ? AssemblyPatternBlock.nop() : ins;
        this.ctx = ctx == null ? AssemblyPatternBlock.nop() : ctx;
        this.backfills = backfills == null ? Set.of() : Collections.unmodifiableSet(backfills);
        this.forbids = forbids == null ? Set.of() : Collections.unmodifiableSet(forbids);
    }

    @Override
    protected int computeHash() {
        int result = 0;
        result += this.ins.hashCode();
        result *= 31;
        result += this.ctx.hashCode();
        result *= 31;
        result += this.backfills.hashCode();
        result *= 31;
        return result += this.forbids.hashCode();
    }

    protected boolean partsEqual(DefaultAssemblyResolvedPatterns that) {
        if (!this.ins.equals(that.ins)) {
            return false;
        }
        if (!this.ctx.equals(that.ctx)) {
            return false;
        }
        if (!this.backfills.equals(that.backfills)) {
            return false;
        }
        return this.forbids.equals(that.forbids);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultAssemblyResolvedPatterns that = (DefaultAssemblyResolvedPatterns)obj;
        return this.partsEqual(that);
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> shiftBuilder(int amt) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.description = this.description;
        builder.cons = this.cons;
        builder.children = this.children;
        builder.right = this.right;
        builder.ins = this.ins.shift(amt);
        builder.ctx = this.ctx;
        builder.backfills = new HashSet<AssemblyResolvedBackfill>();
        for (AssemblyResolvedBackfill bf : this.backfills) {
            builder.backfills.add(bf.shift(amt));
        }
        builder.forbids = new HashSet<AssemblyResolvedPatterns>();
        for (AssemblyResolvedPatterns f : this.forbids) {
            builder.forbids.add(f.shift(amt));
        }
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns shift(int amt) {
        if (amt == 0) {
            return this;
        }
        return (AssemblyResolvedPatterns)this.shiftBuilder(amt).build();
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> truncateBuilder(int amt) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.description = "Truncated: " + this.description;
        builder.cons = this.cons;
        builder.right = this.right;
        builder.ins = this.ins.truncate(amt);
        builder.ctx = this.ctx;
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns truncate(int amt) {
        if (amt == 0) {
            return this;
        }
        return (AssemblyResolvedPatterns)this.truncateBuilder(amt).build();
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolutionBuilder<?, ?> checkNotForbiddenBuilder() {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.forbids = new HashSet<AssemblyResolvedPatterns>();
        for (AssemblyResolvedPatterns f : this.forbids) {
            AssemblyResolvedPatterns check = this.combine(f);
            if (null == check) continue;
            builder.forbids.add(f);
            if (!check.bitsEqual(this)) continue;
            return this.factory.errorBuilder("The result is forbidden by " + String.valueOf(f), this);
        }
        builder.description = this.description;
        builder.cons = this.cons;
        builder.children = this.children;
        builder.right = this.right;
        builder.ins = this.ins;
        builder.ctx = this.ctx;
        builder.backfills = this.backfills;
        return builder;
    }

    @Override
    public AssemblyResolution checkNotForbidden() {
        return this.checkNotForbiddenBuilder().build();
    }

    @Override
    public boolean bitsEqual(AssemblyResolvedPatterns that) {
        return this.ins.equals(that.getInstruction()) && this.ctx.equals(that.getContext());
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> combineBuilder(AssemblyResolvedPatterns that) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.ins = this.ins.combine(that.getInstruction());
        if (builder.ins == null) {
            return null;
        }
        builder.ctx = this.ctx.combine(that.getContext());
        if (builder.ctx == null) {
            return null;
        }
        builder.backfills = new HashSet<AssemblyResolvedBackfill>(this.backfills);
        builder.backfills.addAll(that.getBackfills());
        builder.forbids = new HashSet<AssemblyResolvedPatterns>(this.forbids);
        builder.forbids.addAll(that.getForbids());
        builder.description = this.description;
        builder.cons = this.cons;
        builder.children = this.children;
        builder.right = this.right;
        return builder;
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> combineLessBackfillBuilder(AssemblyResolvedPatterns that, AssemblyResolvedBackfill bf) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> builder = this.combineBuilder(that);
        builder.backfills.remove(bf);
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns combine(AssemblyResolvedPatterns that) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> builder = this.combineBuilder(that);
        return builder == null ? null : (AssemblyResolvedPatterns)builder.build();
    }

    @Override
    public AssemblyResolvedPatterns combineLessBackfill(AssemblyResolvedPatterns that, AssemblyResolvedBackfill bf) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> builder = this.combineLessBackfillBuilder(that, bf);
        return builder == null ? null : (AssemblyResolvedPatterns)builder.build();
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> combineBuilder(AssemblyResolvedBackfill bf) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.description = this.description;
        builder.cons = this.cons;
        builder.children = this.children;
        builder.right = this.right;
        builder.ins = this.ins;
        builder.ctx = this.ctx;
        builder.backfills = new HashSet<AssemblyResolvedBackfill>(this.backfills);
        builder.backfills.add(bf);
        builder.forbids = this.forbids;
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns combine(AssemblyResolvedBackfill bf) {
        return (AssemblyResolvedPatterns)this.combineBuilder(bf).build();
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> withForbidsBuilder(Set<AssemblyResolvedPatterns> more) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.description = this.description;
        builder.cons = this.cons;
        builder.children = this.children;
        builder.right = this.right;
        builder.ins = this.ins;
        builder.ctx = this.ctx;
        builder.backfills = this.backfills;
        builder.forbids = new HashSet<AssemblyResolvedPatterns>(this.forbids);
        builder.forbids.addAll(more);
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns withForbids(Set<AssemblyResolvedPatterns> more) {
        return (AssemblyResolvedPatterns)this.withForbidsBuilder(more).build();
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> withDescriptionBuilder(String description) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.description = description;
        builder.cons = this.cons;
        builder.children = this.children;
        builder.right = this.right;
        builder.ins = this.ins;
        builder.ctx = this.ctx;
        builder.backfills = this.backfills;
        builder.forbids = this.forbids;
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns withDescription(String description) {
        return (AssemblyResolvedPatterns)this.withDescriptionBuilder(description).build();
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> withConstructorBuilder(Constructor cons) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.description = this.description;
        builder.cons = cons;
        builder.children = this.children;
        builder.right = this.right;
        builder.ins = this.ins;
        builder.ctx = this.ctx;
        builder.backfills = this.backfills;
        builder.forbids = this.forbids;
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns withConstructor(Constructor cons) {
        return (AssemblyResolvedPatterns)this.withConstructorBuilder(cons).build();
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> writeContextOpBuilder(ContextOp cop, MaskedLong val) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.description = this.description;
        builder.cons = this.cons;
        builder.children = this.children;
        builder.right = this.right;
        builder.ins = this.ins;
        builder.ctx = this.ctx.writeContextOp(cop, val);
        builder.backfills = this.backfills;
        builder.forbids = this.forbids;
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns writeContextOp(ContextOp cop, MaskedLong val) {
        return (AssemblyResolvedPatterns)this.writeContextOpBuilder(cop, val).build();
    }

    @Override
    public MaskedLong readContextOp(ContextOp cop) {
        return this.ctx.readContextOp(cop);
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> copyAppendDescriptionBuilder(String append) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.description = this.description + ": " + append;
        builder.cons = this.cons;
        builder.children = this.children;
        builder.right = this.right;
        builder.ins = this.ins.copy();
        builder.ctx = this.ctx.copy();
        builder.backfills = this.backfills;
        builder.forbids = this.forbids;
        return builder;
    }

    public AssemblyResolvedPatterns copyAppendDescription(String append) {
        return (AssemblyResolvedPatterns)this.copyAppendDescriptionBuilder(append).build();
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> withRightBuilder(AssemblyResolution right) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.description = this.description;
        builder.cons = this.cons;
        builder.children = this.children;
        builder.right = right;
        builder.ins = this.ins.copy();
        builder.ctx = this.ctx.copy();
        builder.backfills = this.backfills;
        builder.forbids = this.forbids;
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns withRight(AssemblyResolution right) {
        return (AssemblyResolvedPatterns)this.withRightBuilder(right).build();
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> nopLeftSiblingBuilder() {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.description = "nop-left";
        builder.right = this;
        builder.ins = this.ins.copy();
        builder.ctx = this.ctx.copy();
        builder.backfills = this.backfills;
        builder.forbids = this.forbids;
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns nopLeftSibling() {
        return (AssemblyResolvedPatterns)this.nopLeftSiblingBuilder().build();
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> parentBuilder(String description, int opCount) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.description = description;
        builder.cons = this.cons;
        List<AssemblyResolution> allRight = this.getAllRight();
        builder.children = allRight.subList(0, opCount);
        builder.right = allRight.get(opCount);
        builder.ins = this.ins;
        builder.ctx = this.ctx;
        builder.backfills = this.backfills;
        builder.forbids = this.forbids;
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns parent(String description, int opCount) {
        return (AssemblyResolvedPatterns)this.parentBuilder(description, opCount).build();
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> maskOutBuilder(ContextOp cop) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.description = this.description;
        builder.cons = this.cons;
        builder.children = this.children;
        builder.right = this.right;
        builder.ins = this.ins;
        builder.ctx = this.ctx.maskOut(cop);
        builder.backfills = this.backfills;
        builder.forbids = this.forbids;
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns maskOut(ContextOp cop) {
        return (AssemblyResolvedPatterns)this.maskOutBuilder(cop).build();
    }

    @Override
    public AssemblyResolution backfill(RecursiveDescentSolver solver, Map<String, Long> vals) {
        if (!this.hasBackfills()) {
            return this;
        }
        AssemblyResolvedPatterns res = this;
        block0: while (true) {
            for (AssemblyResolvedBackfill bf : res.getBackfills()) {
                AssemblyResolution ar = bf.solve(solver, vals, this);
                if (ar.isError()) continue;
                AssemblyResolvedPatterns rc = (AssemblyResolvedPatterns)ar;
                AssemblyResolvedPatterns check = res.combineLessBackfill(rc, bf);
                if (check == null) {
                    return this.factory.error("Conflict: Backfill " + bf.getDescription(), res);
                }
                res = check;
                continue block0;
            }
            break;
        }
        return res;
    }

    @Override
    public String lineToString() {
        return this.dumpConstructorTree() + ":ins:" + String.valueOf(this.ins) + ",ctx:" + String.valueOf(this.ctx) + " (" + this.description + ")";
    }

    @Override
    public boolean hasBackfills() {
        return !this.backfills.isEmpty();
    }

    private boolean hasForbids() {
        return !this.forbids.isEmpty();
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> solveContextChangesForForbidsBuilder(AssemblyConstructorSemantic sem, Map<String, Long> vals) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.forbids = new HashSet<AssemblyResolvedPatterns>();
        for (AssemblyResolvedPatterns f : this.forbids) {
            AssemblyResolution t = sem.solveContextChanges(f, vals);
            if (!(t instanceof AssemblyResolvedPatterns)) continue;
            AssemblyResolvedPatterns rp = (AssemblyResolvedPatterns)t;
            builder.forbids.add(rp);
        }
        builder.description = this.description;
        builder.cons = this.cons;
        builder.children = this.children;
        builder.right = this.right;
        builder.ins = this.ins;
        builder.ctx = this.ctx;
        builder.backfills = this.backfills;
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns solveContextChangesForForbids(AssemblyConstructorSemantic sem, Map<String, Long> vals) {
        if (!this.hasForbids()) {
            return this;
        }
        return (AssemblyResolvedPatterns)this.solveContextChangesForForbidsBuilder(sem, vals).build();
    }

    @Override
    public int getInstructionLength() {
        int inslen = this.ins.length();
        for (AssemblyResolvedBackfill bf : this.backfills) {
            inslen = Math.max(inslen, bf.getInstructionLength());
        }
        return inslen;
    }

    @Override
    public int getDefinedInstructionLength() {
        int i;
        byte[] imsk = this.ins.getMask();
        for (i = imsk.length - 1; i >= 0 && imsk[i] == 0; --i) {
        }
        return this.ins.getOffset() + i + 1;
    }

    @Override
    public AssemblyPatternBlock getInstruction() {
        return this.ins;
    }

    @Override
    public AssemblyPatternBlock getContext() {
        return this.ctx;
    }

    protected AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder<?> withContextBuilder(AssemblyPatternBlock ctx) {
        AbstractAssemblyResolutionFactory.AbstractAssemblyResolvedPatternsBuilder builder = this.factory.newPatternsBuilder();
        builder.description = this.description;
        builder.cons = this.cons;
        builder.children = this.children;
        builder.right = this.right;
        builder.ins = this.ins;
        builder.ctx = ctx;
        builder.backfills = this.backfills;
        builder.forbids = this.forbids;
        return builder;
    }

    @Override
    public AssemblyResolvedPatterns withContext(AssemblyPatternBlock ctx) {
        return (AssemblyResolvedPatterns)this.withContextBuilder(ctx).build();
    }

    @Override
    public MaskedLong readInstruction(int start, int len) {
        return this.ins.readBytes(start, len);
    }

    @Override
    public MaskedLong readContext(int start, int len) {
        return this.ctx.readBytes(start, len);
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isBackfill() {
        return false;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.hasBackfills() || this.hasForbids();
    }

    @Override
    protected String childrenToString(String indent) {
        StringBuilder sb = new StringBuilder();
        if (super.hasChildren()) {
            sb.append(super.childrenToString(indent) + "\n");
        }
        for (AssemblyResolvedBackfill bf : this.backfills) {
            sb.append(indent);
            sb.append("backfill: " + String.valueOf(bf) + "\n");
        }
        for (AssemblyResolvedPatterns f : this.forbids) {
            sb.append(indent);
            sb.append("forbidden: " + String.valueOf(f) + "\n");
        }
        return sb.substring(0, sb.length() - 1);
    }

    @Override
    public String dumpConstructorTree() {
        StringBuilder sb = new StringBuilder();
        if (this.cons == null) {
            return null;
        }
        sb.append(this.cons.getSourceFile() + ":" + this.cons.getLineno());
        if (this.children == null) {
            return sb.toString();
        }
        ArrayList<String> subs = new ArrayList<String>();
        for (AssemblyResolution c : this.children) {
            AssemblyResolvedPatterns rc;
            String s;
            if (!(c instanceof AssemblyResolvedPatterns) || (s = (rc = (AssemblyResolvedPatterns)c).dumpConstructorTree()) == null) continue;
            subs.add(s);
        }
        if (subs.isEmpty()) {
            return sb.toString();
        }
        sb.append('[');
        sb.append(StringUtils.join(subs, (String)SEP));
        sb.append(']');
        return sb.toString();
    }

    public int getSpecificity() {
        return this.ins.getSpecificity() + this.ctx.getSpecificity();
    }

    @Override
    public Iterable<byte[]> possibleInsVals(AssemblyPatternBlock forCtx) {
        AssemblyPatternBlock ctxCompat = this.ctx.combine(forCtx);
        if (ctxCompat == null) {
            return List.of();
        }
        final Predicate removeForbidden = val -> {
            for (AssemblyResolvedPatterns f : this.forbids) {
                AssemblyPatternBlock vi;
                AssemblyPatternBlock i;
                if (f.getDefinedInstructionLength() > ((byte[])val).length || null == f.getContext().combine(forCtx) || null == (i = f.getInstruction()).combine(vi = AssemblyPatternBlock.fromBytes(this.ins.length() - ((byte[])val).length, val))) continue;
                return false;
            }
            return true;
        };
        return new Iterable<byte[]>(){

            @Override
            public Iterator<byte[]> iterator() {
                return IteratorUtils.filteredIterator(DefaultAssemblyResolvedPatterns.this.ins.possibleVals().iterator(), (Predicate)removeForbidden);
            }
        };
    }

    protected static int getOpIndex(String piece) {
        if (piece.charAt(0) != '\n') {
            return -1;
        }
        return piece.charAt(1) - 65;
    }

    protected static ConstructState getPureRecursion(ConstructState state) {
        List<String> pieces = state.getConstructor().getPrintPieces();
        if (pieces.size() != 1) {
            return null;
        }
        int opIdx = DefaultAssemblyResolvedPatterns.getOpIndex(pieces.get(0));
        if (opIdx < 0) {
            return null;
        }
        ConstructState sub = state.getSubState(opIdx);
        if (sub == null || sub.getConstructor() == null || sub.getConstructor().getParent() != state.getConstructor().getParent()) {
            return null;
        }
        return sub;
    }

    @Override
    public boolean equivalentConstructState(ConstructState state) {
        ConstructState rec = DefaultAssemblyResolvedPatterns.getPureRecursion(state);
        if (rec != null) {
            if (state.getConstructor() == this.cons) {
                assert (this.children.size() == 1);
                AssemblyResolvedPatterns recRes = (AssemblyResolvedPatterns)this.children.get(0);
                return recRes.equivalentConstructState(rec);
            }
            return this.equivalentConstructState(rec);
        }
        if (state.getConstructor() != this.cons) {
            return false;
        }
        int opCount = this.cons.getNumOperands();
        for (int opIdx = 0; opIdx < opCount; ++opIdx) {
            ConstructState subState;
            OperandSymbol opSym = this.cons.getOperand(opIdx);
            Set printed = Arrays.stream(this.cons.getOpsPrintOrder()).boxed().collect(Collectors.toSet());
            if (!(opSym.getDefiningSymbol() instanceof SubtableSymbol)) {
                AssemblyTreeResolver.DBG.println("Operand " + String.valueOf(opSym) + " is not a sub-table");
                continue;
            }
            if (!printed.contains(opIdx)) {
                AssemblyTreeResolver.DBG.println("Operand " + String.valueOf(opSym) + " is hidden");
                continue;
            }
            AssemblyResolvedPatterns child = (AssemblyResolvedPatterns)this.children.get(opIdx);
            if (child.equivalentConstructState(subState = state.getSubState(opIdx))) continue;
            return false;
        }
        return true;
    }

    public Constructor getConstructor() {
        return this.cons;
    }

    public Set<AssemblyResolvedBackfill> getBackfills() {
        return this.backfills;
    }

    public Set<AssemblyResolvedPatterns> getForbids() {
        return this.forbids;
    }
}

