/*
 * Decompiled with CFR 0.152.
 */
package ghidra.asm.wild;

import ghidra.app.plugin.assembler.AssemblySelector;
import ghidra.app.plugin.assembler.sleigh.AbstractSleighAssembler;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseResult;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParser;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyContextGraph;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyDefaultContext;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolutionResults;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseBranch;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.asm.wild.sem.DefaultWildAssemblyResolvedPatterns;
import ghidra.asm.wild.sem.WildAssemblyResolvedPatterns;
import ghidra.asm.wild.sem.WildAssemblyTreeResolver;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;

public class WildSleighAssembler
extends AbstractSleighAssembler<WildAssemblyResolvedPatterns> {
    protected final Set<AssemblyPatternBlock> inputContexts;

    protected WildSleighAssembler(AbstractAssemblyResolutionFactory<WildAssemblyResolvedPatterns, ?> factory, AssemblySelector selector, SleighLanguage lang, AssemblyParser parser, AssemblyDefaultContext defaultContext, Set<AssemblyPatternBlock> inputContexts, AssemblyContextGraph ctxGraph) {
        super(factory, selector, lang, parser, defaultContext, ctxGraph);
        this.inputContexts = inputContexts;
    }

    protected WildSleighAssembler(AbstractAssemblyResolutionFactory<WildAssemblyResolvedPatterns, ?> factory, AssemblySelector selector, Program program, AssemblyParser parser, AssemblyDefaultContext defaultContext, Set<AssemblyPatternBlock> inputContexts, AssemblyContextGraph ctxGraph) {
        super(factory, selector, program, parser, defaultContext, ctxGraph);
        this.inputContexts = inputContexts;
    }

    protected WildAssemblyTreeResolver newResolver(Address at, AssemblyParseBranch tree, AssemblyPatternBlock ctx) {
        return new WildAssemblyTreeResolver(this.factory, this.lang, at, tree, ctx, this.ctxGraph);
    }

    public AssemblyResolutionResults resolveTree(AssemblyParseResult parse, Address at, AssemblyPatternBlock ctx) {
        AssemblyResolutionResults allResults = new AssemblyResolutionResults();
        if (this.inputContexts.isEmpty()) {
            WildSleighAssembler.absorbWithContext(allResults, super.resolveTree(parse, at, ctx), ctx);
            return allResults;
        }
        for (AssemblyPatternBlock inputCtx : this.inputContexts) {
            AssemblyPatternBlock combinedCtx = inputCtx.assign(ctx);
            WildSleighAssembler.absorbWithContext(allResults, super.resolveTree(parse, at, combinedCtx), combinedCtx);
        }
        return allResults;
    }

    protected static void absorbWithContext(AssemblyResolutionResults allResults, AssemblyResolutionResults results, AssemblyPatternBlock ctx) {
        for (AssemblyResolution res : results) {
            AssemblyResolution assemblyResolution;
            Objects.requireNonNull(res);
            int n = 0;
            allResults.add(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DefaultWildAssemblyResolvedPatterns.class}, (Object)assemblyResolution, n)) {
                case 0 -> {
                    DefaultWildAssemblyResolvedPatterns rp = (DefaultWildAssemblyResolvedPatterns)assemblyResolution;
                    yield rp.withContext(ctx);
                }
                default -> res;
            });
        }
    }
}

