/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.lzss;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class LzssCompressionHeader
implements StructConverter {
    public static final int PROBE_BYTES_NEEDED = 8;
    private int signature;
    private int compressionType;
    private int checksum;
    private int decompressedLength;
    private int compressedLength;
    private byte[] padding;

    public static boolean probe(byte[] startBytes) {
        try {
            if (startBytes.length < 8) {
                return false;
            }
            BinaryReader reader = new BinaryReader((ByteProvider)new ByteArrayProvider(startBytes), false);
            int signature = reader.readNextInt();
            int compressionType = reader.readNextInt();
            return signature == 1819964275 && compressionType == 1668246896;
        }
        catch (IOException e) {
            return false;
        }
    }

    public LzssCompressionHeader(ByteProvider provider) throws IOException {
        BinaryReader reader = new BinaryReader(provider, false);
        this.signature = reader.readNextInt();
        this.compressionType = reader.readNextInt();
        this.checksum = reader.readNextInt();
        this.decompressedLength = reader.readNextInt();
        this.compressedLength = reader.readNextInt();
        this.padding = reader.readNextByteArray(364);
    }

    public int getSignature() {
        return this.signature;
    }

    public int getCompressionType() {
        return this.compressionType;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public int getDecompressedLength() {
        return this.decompressedLength;
    }

    public int getCompressedLength() {
        return this.compressedLength;
    }

    public byte[] getPadding() {
        return this.padding;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType((Object)this);
    }
}

