/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.LEB128Info;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class EncodedTypeAddressPair
implements StructConverter {
    private int typeIndex;
    private int address;
    private int typeIndexLength;
    private int addressLength;

    public EncodedTypeAddressPair(BinaryReader reader) throws IOException {
        LEB128Info leb128 = (LEB128Info)reader.readNext(LEB128Info::unsigned);
        this.typeIndex = leb128.asUInt32();
        this.typeIndexLength = leb128.getLength();
        leb128 = (LEB128Info)reader.readNext(LEB128Info::unsigned);
        this.address = leb128.asUInt32();
        this.addressLength = leb128.getLength();
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public int getAddress() {
        return this.address;
    }

    String getDataTypeIdString() {
        return "" + this.typeIndexLength + this.addressLength;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("encoded_type_addr_pair_%d_%d".formatted(this.typeIndexLength, this.addressLength), 0);
        structure.add((DataType)ULEB128, this.typeIndexLength, "type_idx", null);
        structure.add((DataType)ULEB128, this.addressLength, "addr", null);
        structure.setCategoryPath(new CategoryPath("/dex/encoded_type_addr_pair"));
        return structure;
    }
}

