/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.gui.editors.AddressEditorPanel;
import ghidra.feature.vt.gui.editors.AddressEditorPanelListener;
import ghidra.feature.vt.gui.editors.EditableAddress;
import ghidra.feature.vt.gui.provider.markuptable.DisplayableParameterAddress;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.util.exception.InvalidInputException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class EditableParameterAddress
extends DisplayableParameterAddress
implements EditableAddress {
    private final VTMarkupItem markupItem;

    public EditableParameterAddress(Function function, Address currentParameterAddress, VTMarkupItem markupItem) {
        super(function, currentParameterAddress);
        this.markupItem = markupItem;
    }

    @Override
    public AddressEditorPanel getEditorPanel() {
        return new ParameterAddressEditorPanel();
    }

    @Override
    public String getEditorTitle() {
        return "Select Parameter Address";
    }

    @Override
    public VTMarkupItem getMarkupItem() {
        return this.markupItem;
    }

    class ParameterAddressEditorPanel
    extends AddressEditorPanel {
        private JList jList;
        private AddressEditorPanelListener addressPanelListener;

        ParameterAddressEditorPanel() {
            this.buildPanel();
        }

        private void buildPanel() {
            this.setLayout(new BorderLayout());
            final Parameter[] parameters = EditableParameterAddress.this.function.getParameters();
            this.jList = new JList(new ListModel(){

                @Override
                public void addListDataListener(ListDataListener l) {
                }

                public Object getElementAt(int index) {
                    if (index == 0) {
                        return "No Address";
                    }
                    if (index <= parameters.length) {
                        return EditableParameterAddress.this.getDisplayValue(parameters[index - 1]);
                    }
                    return null;
                }

                @Override
                public int getSize() {
                    return parameters.length + 1;
                }

                @Override
                public void removeListDataListener(ListDataListener l) {
                }
            });
            this.jList.setSelectionMode(0);
            int defaultListIndex = this.getListIndex(EditableParameterAddress.this.parameterAddress, parameters);
            this.jList.setSelectedIndex(defaultListIndex);
            JScrollPane scrollPane = new JScrollPane(this.jList);
            this.add((Component)scrollPane, "Center");
            this.jList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    int index = ParameterAddressEditorPanel.this.jList.locationToIndex(e.getPoint());
                    if (index >= 0 && e.getClickCount() == 2 && ParameterAddressEditorPanel.this.addressPanelListener != null) {
                        ParameterAddressEditorPanel.this.addressPanelListener.addressEdited();
                    }
                }
            });
            this.setBorder(BorderFactory.createEmptyBorder(2, 5, 5, 5));
        }

        private int getListIndex(Address desiredParameterAddress, Parameter[] parameters) {
            for (int i = 0; i < parameters.length; ++i) {
                if (!parameters[i].getMinAddress().equals((Object)desiredParameterAddress)) continue;
                return i + 1;
            }
            return 0;
        }

        @Override
        public Address getAddress() throws InvalidInputException {
            int selectedIndex = this.jList.getSelectedIndex();
            if (selectedIndex == -1) {
                throw new InvalidInputException("No list item was selected.");
            }
            if (selectedIndex == 0) {
                return Address.NO_ADDRESS;
            }
            Parameter[] parameters = EditableParameterAddress.this.function.getParameters();
            Parameter parameter = null;
            if (selectedIndex >= 1 && selectedIndex <= parameters.length) {
                parameter = parameters[selectedIndex - 1];
            }
            if (parameter == null) {
                return null;
            }
            Address storageAddress = parameter.getMinAddress();
            if (storageAddress == null) {
                return null;
            }
            EditableParameterAddress.this.parameterAddress = storageAddress;
            return EditableParameterAddress.this.parameterAddress;
        }

        @Override
        public void setAddressPanelListener(AddressEditorPanelListener addressPanelListener) {
            this.addressPanelListener = addressPanelListener;
        }
    }
}

