/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import ghidra.framework.model.DomainFile;
import ghidra.program.model.address.Address;

public class Location {
    private final DomainFile domainFile;
    private final String functionName;
    private final Address entryPoint;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.domainFile == null ? 0 : this.domainFile.getFileID().hashCode());
        result = 31 * result + (this.entryPoint == null ? 0 : this.entryPoint.hashCode());
        result = 31 * result + (this.functionName == null ? 0 : this.functionName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.domainFile == null ? other.domainFile != null : !this.domainFile.getFileID().equals(other.domainFile.getFileID())) {
            return false;
        }
        if (this.entryPoint == null ? other.entryPoint != null : !this.entryPoint.equals((Object)other.entryPoint)) {
            return false;
        }
        return !(this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName));
    }

    public Location(DomainFile domainFile, String functionName, Address entryPoint) {
        this.domainFile = domainFile;
        this.functionName = functionName;
        this.entryPoint = entryPoint;
    }

    public DomainFile getDomainFile() {
        return this.domainFile;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Address getFunctionEntryPoint() {
        return this.entryPoint;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.domainFile != null) {
            sb.append(this.domainFile.getPathname());
            sb.append(":");
        }
        sb.append(this.functionName);
        if (this.entryPoint != null) {
            sb.append(" (");
            sb.append(this.entryPoint.toString());
            sb.append(")");
        }
        return sb.toString();
    }
}

