/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import org.knopflerfish.framework.BundleCapabilityImpl;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleRequirementImpl;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.dto.BundleWireDTO;

public class BundleWireImpl
implements BundleWire {
    private final BundleCapability capability;
    private final BundleRequirement requirement;
    private final BundleGeneration providerGen;
    private final BundleGeneration requirerGen;

    BundleWireImpl(BundleCapability capability, BundleGeneration provider, BundleRequirement requirement, BundleGeneration requirer) {
        this.capability = capability;
        this.providerGen = provider;
        this.requirement = requirement;
        this.requirerGen = requirer;
    }

    @Override
    public BundleCapability getCapability() {
        return this.capability;
    }

    @Override
    public BundleRequirement getRequirement() {
        return this.requirement;
    }

    @Override
    public BundleWiring getProviderWiring() {
        return this.providerGen.bundleRevision.getWiring();
    }

    @Override
    public BundleWiring getRequirerWiring() {
        return this.requirerGen.bundleRevision.getWiring();
    }

    @Override
    public BundleRevision getProvider() {
        return this.providerGen.bundleRevision;
    }

    @Override
    public BundleRevision getRequirer() {
        return this.requirerGen.bundleRevision;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.capability == null ? 0 : this.capability.hashCode());
        result = 31 * result + (this.providerGen == null ? 0 : this.providerGen.hashCode());
        result = 31 * result + (this.requirement == null ? 0 : this.requirement.hashCode());
        result = 31 * result + (this.requirerGen == null ? 0 : this.requirerGen.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleWireImpl)) {
            return false;
        }
        BundleWireImpl other = (BundleWireImpl)obj;
        if (this.capability == null ? other.capability != null : !this.capability.equals(other.capability)) {
            return false;
        }
        if (this.providerGen == null ? other.providerGen != null : !this.providerGen.equals(other.providerGen)) {
            return false;
        }
        if (this.requirement == null ? other.requirement != null : !this.requirement.equals(other.requirement)) {
            return false;
        }
        return !(this.requirerGen == null ? other.requirerGen != null : !this.requirerGen.equals(other.requirerGen));
    }

    BundleGeneration getProviderGeneration() {
        return this.providerGen;
    }

    BundleGeneration getRequirerGeneration() {
        return this.requirerGen;
    }

    BundleWireDTO getDTO() {
        BundleWireDTO res = new BundleWireDTO();
        res.providerWiring = this.providerGen.bundleRevision.getWiringImpl().dtoId;
        res.requirerWiring = this.requirerGen.bundleRevision.getWiringImpl().dtoId;
        res.capability = BundleCapabilityImpl.getRefDTO(this.capability, this.providerGen.bundleRevision);
        res.requirement = BundleRequirementImpl.getRefDTO(this.requirement, this.requirerGen.bundleRevision);
        res.provider = this.providerGen.bundleRevision.dtoId;
        res.requirer = this.requirerGen.bundleRevision.dtoId;
        return res;
    }
}

