/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import java.util.Collection;
import java.util.stream.Collectors;

final class UndefinedStepException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    UndefinedStepException(Collection<SnippetsSuggestedEvent.Suggestion> suggestions) {
        super(UndefinedStepException.createMessage(suggestions), null, false, false);
    }

    private static String createMessage(Collection<SnippetsSuggestedEvent.Suggestion> suggestions) {
        if (suggestions.isEmpty()) {
            return "This step is undefined";
        }
        SnippetsSuggestedEvent.Suggestion first = suggestions.iterator().next();
        StringBuilder sb = new StringBuilder("The step '" + first.getStep() + "'");
        if (suggestions.size() == 1) {
            sb.append(" is undefined.");
        } else {
            sb.append(" and ").append(suggestions.size() - 1).append(" other step(s) are undefined.");
        }
        sb.append("\n");
        if (suggestions.size() == 1) {
            sb.append("You can implement this step using the snippet(s) below:\n\n");
        } else {
            sb.append("You can implement these steps using the snippet(s) below:\n\n");
        }
        String snippets = suggestions.stream().map(SnippetsSuggestedEvent.Suggestion::getSnippets).flatMap(Collection::stream).distinct().collect(Collectors.joining("\n", "", "\n"));
        sb.append(snippets);
        return sb.toString();
    }
}

