/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.RT;
import clojure.lang.Util;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Reflector {
    private static final MethodHandle CAN_ACCESS_PRED;

    private static boolean isJava8() {
        return System.getProperty("java.vm.specification.version").equals("1.8");
    }

    private static boolean canAccess(Method m, Object target) {
        if (CAN_ACCESS_PRED != null) {
            try {
                return CAN_ACCESS_PRED.invoke(m, target);
            }
            catch (Throwable t) {
                throw Util.sneakyThrow(t);
            }
        }
        return true;
    }

    private static Collection<Class> interfaces(Class c) {
        HashSet<Class> interfaces = new HashSet<Class>();
        ArrayDeque toWalk = new ArrayDeque();
        toWalk.addAll(Arrays.asList(c.getInterfaces()));
        Class iface = (Class)toWalk.poll();
        while (iface != null) {
            interfaces.add(iface);
            toWalk.addAll(Arrays.asList(iface.getInterfaces()));
            iface = (Class)toWalk.poll();
        }
        return interfaces;
    }

    private static Method tryFindMethod(Class c, Method m) {
        if (c == null) {
            return null;
        }
        try {
            return c.getMethod(m.getName(), m.getParameterTypes());
        }
        catch (NoSuchMethodException e2) {
            return null;
        }
    }

    private static Method toAccessibleSuperMethod(Method m, Object target) {
        Method selected = m;
        while (selected != null) {
            if (Reflector.canAccess(selected, target)) {
                return selected;
            }
            selected = Reflector.tryFindMethod(selected.getDeclaringClass().getSuperclass(), m);
        }
        Collection<Class> interfaces = Reflector.interfaces(m.getDeclaringClass());
        for (Class c : interfaces) {
            selected = Reflector.tryFindMethod(c, m);
            if (selected == null) continue;
            return selected;
        }
        return null;
    }

    public static Object invokeInstanceMethod(Object target, String methodName, Object[] args) {
        return Reflector.invokeInstanceMethodOfClass(target, target.getClass(), methodName, args);
    }

    public static Object invokeInstanceMethodOfClass(Object target, Class c, String methodName, Object[] args) {
        List methods2 = Reflector.getMethods(c, args.length, methodName, false).stream().map(method -> Reflector.toAccessibleSuperMethod(method, target)).filter(Objects::nonNull).collect(Collectors.toList());
        return Reflector.invokeMatchingMethod(methodName, methods2, c, target, args);
    }

    public static Object invokeInstanceMethodOfClass(Object target, String className, String methodName, Object[] args) {
        return Reflector.invokeInstanceMethodOfClass(target, RT.classForName(className), methodName, args);
    }

    private static Throwable getCauseOrElse(Exception e2) {
        if (e2.getCause() != null) {
            return e2.getCause();
        }
        return e2;
    }

    private static RuntimeException throwCauseOrElseException(Exception e2) {
        if (e2.getCause() != null) {
            throw Util.sneakyThrow(e2.getCause());
        }
        throw Util.sneakyThrow(e2);
    }

    private static String noMethodReport(String methodName, Class contextClass, Object[] args) {
        return "No matching method " + methodName + " found taking " + args.length + " args" + (contextClass != null ? " for " + contextClass : "");
    }

    private static Method matchMethod(List methods2, Object[] args) {
        Method foundm = null;
        for (Method m : methods2) {
            Class[] params = m.getParameterTypes();
            if (!Reflector.isCongruent(params, args) || foundm != null && !Compiler.subsumes(params, foundm.getParameterTypes())) continue;
            foundm = m;
        }
        return foundm;
    }

    private static Object[] widenBoxedArgs(Object[] args) {
        Object[] widenedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            Class<?> valClass = args[i].getClass();
            widenedArgs[i] = valClass == Integer.class || valClass == Short.class || valClass == Byte.class ? Long.valueOf(((Number)args[i]).longValue()) : (valClass == Float.class ? Double.valueOf(((Number)args[i]).doubleValue()) : args[i]);
        }
        return widenedArgs;
    }

    static Object invokeMatchingMethod(String methodName, List methods2, Object target, Object[] args) {
        return Reflector.invokeMatchingMethod(methodName, methods2, target != null ? target.getClass() : null, target, args);
    }

    static Object invokeMatchingMethod(String methodName, List methods2, Class contextClass, Object target, Object[] args) {
        Method m = null;
        if (methods2.isEmpty()) {
            throw new IllegalArgumentException(Reflector.noMethodReport(methodName, contextClass, args));
        }
        if (methods2.size() == 1) {
            m = (Method)methods2.get(0);
        } else {
            m = Reflector.matchMethod(methods2, args);
            if (m == null) {
                args = Reflector.widenBoxedArgs(args);
                m = Reflector.matchMethod(methods2, args);
            }
        }
        if (m == null) {
            throw new IllegalArgumentException(Reflector.noMethodReport(methodName, contextClass, args));
        }
        if (!Modifier.isPublic(m.getDeclaringClass().getModifiers()) || !Reflector.canAccess(m, target)) {
            Method oldm = m;
            if ((m = Reflector.getAsMethodOfAccessibleBase(contextClass, m, target)) == null) {
                throw new IllegalArgumentException("Can't call public method of non-public class: " + oldm.toString());
            }
        }
        try {
            return Reflector.prepRet(m.getReturnType(), m.invoke(target, Reflector.boxArgs(m.getParameterTypes(), args)));
        }
        catch (Exception e2) {
            throw Util.sneakyThrow(Reflector.getCauseOrElse(e2));
        }
    }

    public static Method getAsMethodOfPublicBase(Class c, Method m) {
        for (Class<?> iface : c.getInterfaces()) {
            for (Method im : iface.getMethods()) {
                if (!Reflector.isMatch(im, m)) continue;
                return im;
            }
        }
        Class sc = c.getSuperclass();
        if (sc == null) {
            return null;
        }
        for (Method scm : sc.getMethods()) {
            if (!Reflector.isMatch(scm, m)) continue;
            return scm;
        }
        return Reflector.getAsMethodOfPublicBase(sc, m);
    }

    public static boolean isMatch(Method lhs, Method rhs) {
        Class<?>[] types2;
        if (!lhs.getName().equals(rhs.getName()) || !Modifier.isPublic(lhs.getDeclaringClass().getModifiers())) {
            return false;
        }
        Class<?>[] types1 = lhs.getParameterTypes();
        if (types1.length != (types2 = rhs.getParameterTypes()).length) {
            return false;
        }
        boolean match = true;
        for (int i = 0; i < types1.length; ++i) {
            if (types1[i].isAssignableFrom(types2[i])) continue;
            match = false;
            break;
        }
        return match;
    }

    public static Method getAsMethodOfAccessibleBase(Class c, Method m, Object target) {
        for (Class<?> iface : c.getInterfaces()) {
            for (Method im : iface.getMethods()) {
                if (!Reflector.isAccessibleMatch(im, m, target)) continue;
                return im;
            }
        }
        Class sc = c.getSuperclass();
        if (sc == null) {
            return null;
        }
        for (Method scm : sc.getMethods()) {
            if (!Reflector.isAccessibleMatch(scm, m, target)) continue;
            return scm;
        }
        return Reflector.getAsMethodOfAccessibleBase(sc, m, target);
    }

    public static boolean isAccessibleMatch(Method lhs, Method rhs, Object target) {
        Class<?>[] types2;
        if (!(lhs.getName().equals(rhs.getName()) && Modifier.isPublic(lhs.getDeclaringClass().getModifiers()) && Reflector.canAccess(lhs, target))) {
            return false;
        }
        Class<?>[] types1 = lhs.getParameterTypes();
        if (types1.length != (types2 = rhs.getParameterTypes()).length) {
            return false;
        }
        boolean match = true;
        for (int i = 0; i < types1.length; ++i) {
            if (types1[i].isAssignableFrom(types2[i])) continue;
            match = false;
            break;
        }
        return match;
    }

    public static Object invokeConstructor(Class c, Object[] args) {
        try {
            Constructor<?>[] allctors = c.getConstructors();
            ArrayList<Constructor> ctors = new ArrayList<Constructor>();
            for (int i = 0; i < allctors.length; ++i) {
                Constructor ctor = allctors[i];
                if (ctor.getParameterTypes().length != args.length) continue;
                ctors.add(ctor);
            }
            if (ctors.isEmpty()) {
                throw new IllegalArgumentException("No matching ctor found for " + c);
            }
            if (ctors.size() == 1) {
                Constructor ctor = (Constructor)ctors.get(0);
                return ctor.newInstance(Reflector.boxArgs(ctor.getParameterTypes(), args));
            }
            for (Constructor ctor : ctors) {
                Class[] params = ctor.getParameterTypes();
                if (!Reflector.isCongruent(params, args)) continue;
                Object[] boxedArgs = Reflector.boxArgs(params, args);
                return ctor.newInstance(boxedArgs);
            }
            throw new IllegalArgumentException("No matching ctor found for " + c);
        }
        catch (Exception e2) {
            throw Util.sneakyThrow(Reflector.getCauseOrElse(e2));
        }
    }

    public static Object invokeStaticMethodVariadic(String className, String methodName, Object ... args) {
        return Reflector.invokeStaticMethod(className, methodName, args);
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] args) {
        Class c = RT.classForName(className);
        return Reflector.invokeStaticMethod(c, methodName, args);
    }

    public static Object invokeStaticMethod(Class c, String methodName, Object[] args) {
        if (methodName.equals("new")) {
            return Reflector.invokeConstructor(c, args);
        }
        List<Method> methods2 = Reflector.getMethods(c, args.length, methodName, true);
        return Reflector.invokeMatchingMethod(methodName, methods2, null, args);
    }

    public static Object getStaticField(String className, String fieldName) {
        Class c = RT.classForName(className);
        return Reflector.getStaticField(c, fieldName);
    }

    public static Object getStaticField(Class c, String fieldName) {
        Field f = Reflector.getField(c, fieldName, true);
        if (f != null) {
            try {
                return Reflector.prepRet(f.getType(), f.get(null));
            }
            catch (IllegalAccessException e2) {
                throw Util.sneakyThrow(e2);
            }
        }
        throw new IllegalArgumentException("No matching field found: " + fieldName + " for " + c);
    }

    public static Object setStaticField(String className, String fieldName, Object val2) {
        Class c = RT.classForName(className);
        return Reflector.setStaticField(c, fieldName, val2);
    }

    public static Object setStaticField(Class c, String fieldName, Object val2) {
        Field f = Reflector.getField(c, fieldName, true);
        if (f != null) {
            try {
                f.set(null, Reflector.boxArg(f.getType(), val2));
            }
            catch (IllegalAccessException e2) {
                throw Util.sneakyThrow(e2);
            }
            return val2;
        }
        throw new IllegalArgumentException("No matching field found: " + fieldName + " for " + c);
    }

    public static Object getInstanceField(Object target, String fieldName) {
        Class<?> c = target.getClass();
        Field f = Reflector.getField(c, fieldName, false);
        if (f != null) {
            try {
                return Reflector.prepRet(f.getType(), f.get(target));
            }
            catch (IllegalAccessException e2) {
                throw Util.sneakyThrow(e2);
            }
        }
        throw new IllegalArgumentException("No matching field found: " + fieldName + " for " + target.getClass());
    }

    public static Object setInstanceField(Object target, String fieldName, Object val2) {
        Class<?> c = target.getClass();
        Field f = Reflector.getField(c, fieldName, false);
        if (f != null) {
            try {
                f.set(target, Reflector.boxArg(f.getType(), val2));
            }
            catch (IllegalAccessException e2) {
                throw Util.sneakyThrow(e2);
            }
            return val2;
        }
        throw new IllegalArgumentException("No matching field found: " + fieldName + " for " + target.getClass());
    }

    public static Object invokeNoArgInstanceMember(Object target, String name2) {
        return Reflector.invokeNoArgInstanceMember(target, name2, false);
    }

    public static Object invokeNoArgInstanceMember(Object target, String name2, boolean requireField) {
        Class<?> c = target.getClass();
        if (requireField) {
            Field f = Reflector.getField(c, name2, false);
            if (f != null) {
                return Reflector.getInstanceField(target, name2);
            }
            throw new IllegalArgumentException("No matching field found: " + name2 + " for " + target.getClass());
        }
        List<Method> meths = Reflector.getMethods(c, 0, name2, false);
        if (meths.size() > 0) {
            return Reflector.invokeMatchingMethod(name2, meths, target, RT.EMPTY_ARRAY);
        }
        return Reflector.getInstanceField(target, name2);
    }

    public static Object invokeInstanceMember(Object target, String name2) {
        Class<?> c = target.getClass();
        Field f = Reflector.getField(c, name2, false);
        if (f != null) {
            try {
                return Reflector.prepRet(f.getType(), f.get(target));
            }
            catch (IllegalAccessException e2) {
                throw Util.sneakyThrow(e2);
            }
        }
        return Reflector.invokeInstanceMethod(target, name2, RT.EMPTY_ARRAY);
    }

    public static Object invokeInstanceMember(String name2, Object target, Object arg1) {
        Class<?> c = target.getClass();
        Field f = Reflector.getField(c, name2, false);
        if (f != null) {
            try {
                f.set(target, Reflector.boxArg(f.getType(), arg1));
            }
            catch (IllegalAccessException e2) {
                throw Util.sneakyThrow(e2);
            }
            return arg1;
        }
        return Reflector.invokeInstanceMethod(target, name2, new Object[]{arg1});
    }

    public static Object invokeInstanceMember(String name2, Object target, Object ... args) {
        return Reflector.invokeInstanceMethod(target, name2, args);
    }

    public static Field getField(Class c, String name2, boolean getStatics) {
        Field[] allfields = c.getFields();
        for (int i = 0; i < allfields.length; ++i) {
            if (!name2.equals(allfields[i].getName()) || Modifier.isStatic(allfields[i].getModifiers()) != getStatics) continue;
            return allfields[i];
        }
        return null;
    }

    public static List<Method> getMethods(Class c, int arity, String name2, boolean getStatics) {
        int i;
        Method[] allmethods = c.getMethods();
        ArrayList<Method> methods2 = new ArrayList<Method>();
        ArrayList<Method> bridgeMethods = new ArrayList<Method>();
        for (i = 0; i < allmethods.length; ++i) {
            Method method = allmethods[i];
            if (!name2.equals(method.getName()) || Modifier.isStatic(method.getModifiers()) != getStatics || method.getParameterTypes().length != arity) continue;
            try {
                if (method.isBridge() && c.getMethod(method.getName(), method.getParameterTypes()).equals(method)) {
                    bridgeMethods.add(method);
                    continue;
                }
                methods2.add(method);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (methods2.isEmpty()) {
            methods2.addAll(bridgeMethods);
        }
        if (!getStatics && c.isInterface()) {
            allmethods = Object.class.getMethods();
            for (i = 0; i < allmethods.length; ++i) {
                if (!name2.equals(allmethods[i].getName()) || Modifier.isStatic(allmethods[i].getModifiers()) != getStatics || allmethods[i].getParameterTypes().length != arity) continue;
                methods2.add(allmethods[i]);
            }
        }
        return methods2;
    }

    private static Object coerceAdapterReturn(Object ret, Class targetType) {
        if (targetType.isPrimitive()) {
            switch (targetType.getName()) {
                case "boolean": {
                    return RT.booleanCast(ret);
                }
                case "long": {
                    return RT.longCast(ret);
                }
                case "double": {
                    return RT.doubleCast(ret);
                }
                case "int": {
                    return RT.intCast(ret);
                }
                case "short": {
                    return RT.shortCast(ret);
                }
                case "byte": {
                    return RT.byteCast(ret);
                }
                case "float": {
                    return Float.valueOf(RT.floatCast(ret));
                }
            }
        }
        return ret;
    }

    static Object boxArg(Class paramType, Object arg) {
        if (arg instanceof IFn && Compiler.FISupport.maybeFIMethod(paramType) != null && !paramType.isInstance(arg)) {
            return Proxy.newProxyInstance(RT.baseLoader(), new Class[]{paramType}, (proxy2, method, methodArgs) -> {
                Object ret = ((IFn)arg).applyTo(RT.seq(methodArgs));
                return Reflector.coerceAdapterReturn(ret, method.getReturnType());
            });
        }
        if (!paramType.isPrimitive()) {
            return paramType.cast(arg);
        }
        if (paramType == Boolean.TYPE) {
            return Boolean.class.cast(arg);
        }
        if (paramType == Character.TYPE) {
            return Character.class.cast(arg);
        }
        if (arg instanceof Number) {
            Number n = (Number)arg;
            if (paramType == Integer.TYPE) {
                return n.intValue();
            }
            if (paramType == Float.TYPE) {
                return Float.valueOf(n.floatValue());
            }
            if (paramType == Double.TYPE) {
                return n.doubleValue();
            }
            if (paramType == Long.TYPE) {
                return n.longValue();
            }
            if (paramType == Short.TYPE) {
                return n.shortValue();
            }
            if (paramType == Byte.TYPE) {
                return n.byteValue();
            }
        }
        throw new IllegalArgumentException("Unexpected param type, expected: " + paramType + ", given: " + arg.getClass().getName());
    }

    static Object[] boxArgs(Class[] params, Object[] args) {
        if (params.length == 0) {
            return null;
        }
        Object[] ret = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object arg = args[i];
            Class paramType = params[i];
            ret[i] = Reflector.boxArg(paramType, arg);
        }
        return ret;
    }

    public static boolean paramArgTypeMatch(Class paramType, Class argType) {
        if (argType == null) {
            return !paramType.isPrimitive();
        }
        if (paramType == argType || paramType.isAssignableFrom(argType)) {
            return true;
        }
        if (Compiler.FISupport.maybeFIMethod(paramType) != null && IFn.class.isAssignableFrom(argType)) {
            return true;
        }
        if (paramType == Integer.TYPE) {
            return argType == Integer.class || argType == Long.TYPE || argType == Long.class || argType == Short.TYPE || argType == Byte.TYPE;
        }
        if (paramType == Float.TYPE) {
            return argType == Float.class || argType == Double.TYPE;
        }
        if (paramType == Double.TYPE) {
            return argType == Double.class || argType == Float.TYPE;
        }
        if (paramType == Long.TYPE) {
            return argType == Long.class || argType == Integer.TYPE || argType == Short.TYPE || argType == Byte.TYPE;
        }
        if (paramType == Character.TYPE) {
            return argType == Character.class;
        }
        if (paramType == Short.TYPE) {
            return argType == Short.class;
        }
        if (paramType == Byte.TYPE) {
            return argType == Byte.class;
        }
        if (paramType == Boolean.TYPE) {
            return argType == Boolean.class;
        }
        return false;
    }

    static boolean isCongruent(Class[] params, Object[] args) {
        boolean ret = false;
        if (args == null) {
            return params.length == 0;
        }
        if (params.length == args.length) {
            ret = true;
            for (int i = 0; ret && i < params.length; ++i) {
                Object arg = args[i];
                Class<?> argType = arg == null ? null : arg.getClass();
                Class paramType = params[i];
                ret = Reflector.paramArgTypeMatch(paramType, argType);
            }
        }
        return ret;
    }

    public static Object prepRet(Class c, Object x) {
        if (!c.isPrimitive() && c != Boolean.class) {
            return x;
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? Boolean.TRUE : Boolean.FALSE;
        }
        return x;
    }

    static {
        MethodHandle pred = null;
        try {
            if (!Reflector.isJava8()) {
                pred = MethodHandles.lookup().findVirtual(Method.class, "canAccess", MethodType.methodType(Boolean.TYPE, Object.class));
            }
        }
        catch (Throwable t) {
            Util.sneakyThrow(t);
        }
        CAN_ACCESS_PRED = pred;
    }
}

