﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces-instances/WorkspacesInstances_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WorkspacesInstances {
namespace Model {
/**
 * <p>Returns the unique identifier for the newly created WorkSpaces
 * Instance.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/CreateWorkspaceInstanceResponse">AWS
 * API Reference</a></p>
 */
class CreateWorkspaceInstanceResult {
 public:
  AWS_WORKSPACESINSTANCES_API CreateWorkspaceInstanceResult() = default;
  AWS_WORKSPACESINSTANCES_API CreateWorkspaceInstanceResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WORKSPACESINSTANCES_API CreateWorkspaceInstanceResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Unique identifier assigned to the newly created WorkSpaces Instance.</p>
   */
  inline const Aws::String& GetWorkspaceInstanceId() const { return m_workspaceInstanceId; }
  template <typename WorkspaceInstanceIdT = Aws::String>
  void SetWorkspaceInstanceId(WorkspaceInstanceIdT&& value) {
    m_workspaceInstanceIdHasBeenSet = true;
    m_workspaceInstanceId = std::forward<WorkspaceInstanceIdT>(value);
  }
  template <typename WorkspaceInstanceIdT = Aws::String>
  CreateWorkspaceInstanceResult& WithWorkspaceInstanceId(WorkspaceInstanceIdT&& value) {
    SetWorkspaceInstanceId(std::forward<WorkspaceInstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateWorkspaceInstanceResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_workspaceInstanceId;
  bool m_workspaceInstanceIdHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkspacesInstances
}  // namespace Aws
