/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.svek.image.EntityImageStateCommon;

public class EntityImageStateEmptyDescription
extends EntityImageStateCommon {
    private static final int MIN_WIDTH = 50;
    private static final int MIN_HEIGHT = 40;

    public EntityImageStateEmptyDescription(Entity entity) {
        super(entity);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.title.calculateDimension(stringBounder);
        XDimension2D result = dim.delta(10.0);
        return result.atLeast(50.0, 40.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimDesc = this.title.calculateDimension(stringBounder);
        UStroke stroke = this.getStyleState().getStroke(this.lineConfig.getColors());
        ug = this.applyColor(ug);
        ug = ug.apply(stroke);
        ug.draw(this.getShape(dimTotal));
        double xDesc = (dimTotal.getWidth() - dimDesc.getWidth()) / 2.0;
        double yDesc = (dimTotal.getHeight() - dimDesc.getHeight()) / 2.0;
        this.title.drawU(ug.apply(new UTranslate(xDesc, yDesc)));
        if (this.url != null) {
            ug.closeUrl();
        }
    }
}

