---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, sciences, biologie, protéines, ADN, 
              acides nucléiques, alignement de séquence, alignement multiple, 
              Clustal, génomique, électrophorégramme, électrophérogramme, 
              structure des protéines
---

# Comment présenter des séquences nucléiques ou protéiques ?

## Alignements de séquences

L'extension [TeXshade](ctanpkg:texshade), d'Eric Beitz, permet de présenter 
des alignements multiples de séquences nucléiques ou protéiques. Vous devez
avoir réalisé l'alignement auparavant, et préparer un fichier ALN, MSA 
ou Fasta (aligné). Si les séquence sont longues, cette extension peut les 
représenter de façon graphique, par des motifs colorés (*fingerprints*) 
au lieu d'afficher chaque résidu.

:::{todo} Donner un exemple concret, y compris la procédure d'alignement.
:::

Si votre alignement est de taille conséquente, l'utilisation 
de [TeXshade](ctanpkg:texshade) nécessitera que vous augmentiez les paramètres
`main_memory` et `stack_size` dans le fichier `texmf.cnf`.


## Autres représentations de séquences biologiques

### Avec l'extension <ctanpkg:pgfmolbio>

L'extension <ctanpkg:pgfmolbio> propose de représenter :
- des chromatogrammes (type séquençage Sanger) ;
- des domaines le long d'une séquence.

```
%!TEX engine=lualatex
\documentclass{article}
  \usepackage[domains]{pgfmolbio}
  \usetikzlibrary{decorations.pathreplacing}
  \pagestyle{empty}
  
\begin{document}
\Large
\begin{pmbdomains}[name=Bidulase \TeX ique]{101}
  \addfeature[description={\TeX}]{domain}{10}{25}
  \addfeature[description={\LaTeX}]{domain}{40}{70}
  \addfeature[description=Région 1]{range}{15}{30}
  \addfeature[description=Région 2]{range}{25}{60}
  \addfeature[description=Et la fin,%
              style={very thick, draw=red},%
              range font=\footnotesize\textcolor{red}]{range}{68}{86}
\end{pmbdomains}
\end{document}
```

Vous pourrez noter que l'extension demande d'utiliser luaLaTeX. 
La [documentation](texdoc:pgfmolbio) de l'extension propose toutefois 
une méthode pour pouvoir intégrer ses graphiques dans des fichiers
de moteurs LaTeX plus anciens.


### Avec l'extension [TeXtopo](ctanpkg:textopo)

L'extension [TeXtopo](ctanpkg:textopo) permet de dessiner 
la structure secondaire d'une protéine et 
[son repliement](wpfr:Repliement_des_protéines) 
en structures transmembranaires.

:::{todo} Ajouter un exemple.
:::

:::{sources}
- [TEXshade: shading and labeling of multiple sequence alignments using LATEX2 epsilon](https://pubmed.ncbi.nlm.nih.gov/10842735/),
  sur le site de la [National Library of Medecine](https://www.ncbi.nlm.nih.gov/)
- [T(E)Xtopo: shaded membrane protein topology plots in LAT(E)X2epsilon](https://pubmed.ncbi.nlm.nih.gov/11159320/),
  sur le site de la [National Library of Medecine](https://www.ncbi.nlm.nih.gov/)
- [Highlight CpG sites with Texshade](https://tex.stackexchange.com/q/400703),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::