/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.tree.Node;
import ai.grazie.rules.util.regex.Regex;
import java.util.BitSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class HeadRelations {
    static final String ROOT = "root";
    static final String PUNCT = "punct";
    static final String FLAT_DEP = "flat_dep";
    private static final String[] knownRelations = new String[]{"root", "punct", "nsubj", "nsubj:pass", "nsubj:outer", "csubj", "csubj:pass", "expl", "expl:pv", "obj", "iobj", "obl", "obl:tmod", "obl:npmod", "obl:agent", "nmod", "nmod:poss", "nmod:npmod", "nmod:tmod", "nummod", "nummod:gov", "nummod:entity", "amod", "appos", "advmod", "compound", "compound:prt", "cop", "cop:pass", "aux", "aux:pass", "xcomp", "xcomp:pred", "ccomp", "parataxis", "parataxis:discourse", "advcl", "advcl:relcl", "acl", "acl:relcl", "conj", "cc", "cc:preconj", "case", "mark", "det", "det:predet", "det:poss", "det:nummod", "det:numgov", "discourse", "vocative", "flat", "flat:foreign", "flat:name", "flat:title", "flat:range", "flat:abs", "flat:repeat", "list", "fixed", "goeswith", "orphan", "dep", "<unk>", "flat_dep"};
    private static volatile String[] byId;
    private static final Map<String, Short> byRelation;
    private static final Map<String, Matcher> matcherCache;

    public static int maxKnownId() {
        return knownRelations.length;
    }

    public static String byId(short id) {
        return byId[id];
    }

    static short internKnown(String relation) {
        Short result = byRelation.get(relation);
        if (result == null) {
            throw new IllegalArgumentException("Unknown head relation " + relation + "; is it a typo? If it's valid, add it to HeadRelations.knownRelations");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static short internDynamic(@NotNull String relation) {
        Short existing = byRelation.get(relation);
        if (existing != null) {
            return existing;
        }
        Map<String, Short> map = byRelation;
        synchronized (map) {
            existing = byRelation.get(relation);
            if (existing != null) {
                return existing;
            }
            if (byRelation.size() == Short.MAX_VALUE) {
                throw new IllegalStateException("Too many head relations");
            }
            String[] old = byId;
            short newId = (short)old.length;
            String[] grown = new String[old.length + 1];
            System.arraycopy(old, 0, grown, 0, old.length);
            grown[old.length] = relation;
            byId = grown;
            byRelation.put(relation, newId);
            return newId;
        }
    }

    static Matcher matcher(@Language(value="RegExp") String relations) {
        return matcherCache.computeIfAbsent(relations, HeadRelations::doCreateMatcher);
    }

    private static Set<String> getMatchingRelations(String relations) {
        Set values = Regex.parse(relations).possibleValues();
        if (values == null && (values = ((StreamEx)StreamEx.of((Object[])knownRelations).filter(Pattern.compile(relations).asMatchPredicate())).toSet()).isEmpty()) {
            throw new IllegalArgumentException("The regex " + relations + " matches no known relations, is a typo? If not, add some relations to HeadRelations.knownRelations");
        }
        return values;
    }

    private static Matcher doCreateMatcher(String relations) {
        Set<String> values = HeadRelations.getMatchingRelations(relations);
        if (values.size() == HeadRelations.maxKnownId()) {
            return new Matcher(null){

                @Override
                public boolean matches(Node node) {
                    return true;
                }
            };
        }
        if (values.size() == 1) {
            final short rel = HeadRelations.internKnown(values.iterator().next());
            return new Matcher(values){

                @Override
                public boolean matches(Node node) {
                    return node.headRel == rel;
                }
            };
        }
        final BitSet bits = new BitSet();
        for (String value : values) {
            bits.set(HeadRelations.internKnown(value));
        }
        return new Matcher(values){

            @Override
            public boolean matches(Node node) {
                return bits.get(node.headRel);
            }
        };
    }

    static {
        byRelation = new ConcurrentHashMap<String, Short>();
        String[] all = new String[knownRelations.length + 1];
        for (short i = 1; i <= knownRelations.length; i = (short)(i + 1)) {
            String rel;
            all[i] = rel = knownRelations[i - 1];
            byRelation.put(rel, i);
        }
        byId = all;
        matcherCache = new ConcurrentHashMap<String, Matcher>();
    }

    public static abstract class Matcher {
        final Set<String> possibleRelations;

        protected Matcher(Set<String> possibleRelations) {
            this.possibleRelations = possibleRelations;
        }

        public abstract boolean matches(Node var1);
    }
}

