/*
 * Decompiled with CFR 0.152.
 */
package de.tuberlin.polymake.common;

import de.tuberlin.polymake.common.MsgQueue;
import de.tuberlin.polymake.common.PolymakeFrame;
import de.tuberlin.polymake.common.geometry.EmbeddedGeometries;
import de.tuberlin.polymake.common.io.GeometryParserIf;
import de.tuberlin.polymake.common.io.SimpleGeometryParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.util.HashMap;

public abstract class PolymakeControl {
    protected boolean alive = true;
    protected boolean answer = false;
    protected SimpleGeometryParser parser;
    protected GeometryParserIf geometryParser;
    protected BufferedReader clientReader;
    protected BufferedReader psReader;
    protected Pipe.SinkChannel pipeSink;
    protected HashMap<String, PolymakeFrame> frameMap = new HashMap(8);
    protected MsgQueue clientQueue = new MsgQueue();
    protected ByteBuffer bbuf = ByteBuffer.allocate(32);
    protected EmbeddedGeometries geometry;

    public PolymakeControl(BufferedReader bufferedReader, BufferedReader bufferedReader2, Pipe.SinkChannel sinkChannel, GeometryParserIf geometryParserIf) throws IOException {
        this.clientReader = bufferedReader2;
        this.psReader = bufferedReader;
        this.pipeSink = sinkChannel;
        this.geometryParser = geometryParserIf;
        this.initGeometry();
    }

    public abstract void update() throws IOException;

    public abstract PolymakeFrame createFrame(String var1);

    public void removeFrame(String string) throws IOException {
        this.answer = false;
        PolymakeFrame polymakeFrame = this.frameMap.remove(string);
        if (polymakeFrame != null) {
            polymakeFrame.forget();
        }
        if (this.frameMap.size() == 0) {
            this.alive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMessage(String string, char c, boolean bl) throws IOException {
        MsgQueue msgQueue = this.clientQueue;
        synchronized (msgQueue) {
            this.answer = bl;
            boolean bl2 = this.clientQueue.isEmpty();
            this.clientQueue.pushBack(string);
            if (bl2) {
                this.bbuf.clear();
                this.bbuf.putChar(c);
                this.bbuf.flip();
                this.pipeSink.write(this.bbuf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popMessage() {
        MsgQueue msgQueue = this.clientQueue;
        synchronized (msgQueue) {
            if (!this.clientQueue.isEmpty()) {
                this.clientQueue.popFront();
            }
        }
    }

    public synchronized boolean getAnswer() {
        return this.answer;
    }

    public boolean isAlive() {
        return this.alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        MsgQueue msgQueue = this.clientQueue;
        synchronized (msgQueue) {
            return (String)this.clientQueue.front();
        }
    }

    public void initGeometry() throws IOException {
        this.geometry = this.geometryParser.parse(this.psReader);
    }

    public GeometryParserIf getGeometryParser() {
        return this.geometryParser;
    }
}

