/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import org.scilab.forge.jlatexmath.Box;

public class JavaFontRenderingBox
extends Box {
    private static final Graphics2D TEMPGRAPHIC = new BufferedImage(1, 1, 2).createGraphics();
    private static Font font = new Font("Serif", 0, 10);
    private TextLayout text;
    private float size;
    private static TextAttribute KERNING;
    private static Integer KERNING_ON;
    private static TextAttribute LIGATURES;
    private static Integer LIGATURES_ON;

    public JavaFontRenderingBox(String str, int type, float size, Font f, boolean kerning) {
        this.size = size;
        if (kerning && KERNING != null) {
            Hashtable<TextAttribute, Integer> map = new Hashtable<TextAttribute, Integer>();
            map.put(KERNING, KERNING_ON);
            map.put(LIGATURES, LIGATURES_ON);
            f = f.deriveFont(map);
        }
        this.text = new TextLayout(str, f.deriveFont(type), TEMPGRAPHIC.getFontRenderContext());
        Rectangle2D rect = this.text.getBounds();
        this.height = (float)(-rect.getY() * (double)size / 10.0);
        this.depth = (float)(rect.getHeight() * (double)size / 10.0) - this.height;
        this.width = (float)((rect.getWidth() + rect.getX() + (double)0.4f) * (double)size / 10.0);
    }

    public JavaFontRenderingBox(String str, int type, float size) {
        this(str, type, size, font, true);
    }

    public static void setFont(String name) {
        font = new Font(name, 0, 10);
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        this.drawDebug(g2, x, y);
        g2.translate(x, y);
        g2.scale(0.1 * (double)this.size, 0.1 * (double)this.size);
        this.text.draw(g2, 0.0f, 0.0f);
        g2.scale(10.0f / this.size, 10.0f / this.size);
        g2.translate(-x, -y);
    }

    @Override
    public int getLastFontId() {
        return 0;
    }

    static {
        try {
            KERNING = (TextAttribute)TextAttribute.class.getField("KERNING").get(TextAttribute.class);
            KERNING_ON = (Integer)TextAttribute.class.getField("KERNING_ON").get(TextAttribute.class);
            LIGATURES = (TextAttribute)TextAttribute.class.getField("LIGATURES").get(TextAttribute.class);
            LIGATURES_ON = (Integer)TextAttribute.class.getField("LIGATURES_ON").get(TextAttribute.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

