/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p4nodes;

import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.Spacings;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class InteractiveNodePlacer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> HIERARCHY_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.HIERARCHICAL_PORT_POSITION_PROCESSOR);
    private Spacings spacings;

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        if (graph.getProperty(InternalProperties.GRAPH_PROPERTIES).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return HIERARCHY_PROCESSING_ADDITIONS;
        }
        return null;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Interactive node placement", 1.0f);
        this.spacings = layeredGraph.getProperty(InternalProperties.SPACINGS);
        for (Layer layer : layeredGraph) {
            this.placeNodes(layer);
        }
        monitor.done();
    }

    private void placeNodes(Layer layer) {
        double minValidY = Double.NEGATIVE_INFINITY;
        LNode.NodeType prevNodeType = LNode.NodeType.NORMAL;
        for (LNode node : layer) {
            double spacing;
            LNode.NodeType nodeType = node.getType();
            if (nodeType != LNode.NodeType.NORMAL) {
                Double originalYCoordinate = node.getProperty(InternalProperties.ORIGINAL_DUMMY_NODE_POSITION);
                if (originalYCoordinate == null) {
                    minValidY = Math.max(minValidY, 0.0);
                    node.getPosition().y = minValidY + this.spacings.getVerticalSpacing(nodeType, prevNodeType);
                } else {
                    node.getPosition().y = originalYCoordinate;
                }
            }
            if (node.getPosition().y < minValidY + (spacing = this.spacings.getVerticalSpacing(nodeType, prevNodeType)) + node.getMargin().top) {
                node.getPosition().y = minValidY + spacing + node.getMargin().top;
            }
            minValidY = node.getPosition().y + node.getSize().y + node.getMargin().bottom;
            prevNodeType = nodeType;
        }
    }
}

