/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.cluster.RerouteResponse;
import org.opensearch.client.opensearch.cluster.reroute.ClusterRerouteMetric;
import org.opensearch.client.opensearch.cluster.reroute.Command;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class RerouteRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RerouteRequest> {
    @Nullable
    private final Time clusterManagerTimeout;
    @Nonnull
    private final List<Command> commands;
    @Nullable
    private final Boolean dryRun;
    @Nullable
    private final Boolean explain;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nonnull
    private final List<ClusterRerouteMetric> metric;
    @Nullable
    private final Boolean retryFailed;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<RerouteRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteRequest::setupRerouteRequestDeserializer);
    public static final Endpoint<RerouteRequest, RerouteResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RerouteRequest, RerouteResponse>(request -> "POST", request -> "/_cluster/reroute", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, RerouteResponse._DESERIALIZER);

    private RerouteRequest(Builder builder) {
        super(builder);
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.commands = ApiTypeHelper.unmodifiable(builder.commands);
        this.dryRun = builder.dryRun;
        this.explain = builder.explain;
        this.masterTimeout = builder.masterTimeout;
        this.metric = ApiTypeHelper.unmodifiable(builder.metric);
        this.retryFailed = builder.retryFailed;
        this.timeout = builder.timeout;
    }

    public static RerouteRequest of(Function<Builder, ObjectBuilder<RerouteRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nonnull
    public final List<Command> commands() {
        return this.commands;
    }

    @Nullable
    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Nullable
    public final Boolean explain() {
        return this.explain;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nonnull
    public final List<ClusterRerouteMetric> metric() {
        return this.metric;
    }

    @Nullable
    public final Boolean retryFailed() {
        return this.retryFailed;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.commands)) {
            generator.writeKey("commands");
            generator.writeStartArray();
            for (Command item0 : this.commands) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRerouteRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::commands, JsonpDeserializer.arrayDeserializer(Command._DESERIALIZER), "commands");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", this.clusterManagerTimeout._toJsonString());
        }
        if (this.dryRun != null) {
            params.put("dry_run", String.valueOf(this.dryRun));
        }
        if (this.explain != null) {
            params.put("explain", String.valueOf(this.explain));
        }
        if (this.masterTimeout != null) {
            params.put("master_timeout", this.masterTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(this.metric)) {
            params.put("metric", this.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (this.retryFailed != null) {
            params.put("retry_failed", String.valueOf(this.retryFailed));
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterManagerTimeout);
        result = 31 * result + Objects.hashCode(this.commands);
        result = 31 * result + Objects.hashCode(this.dryRun);
        result = 31 * result + Objects.hashCode(this.explain);
        result = 31 * result + Objects.hashCode(this.masterTimeout);
        result = 31 * result + Objects.hashCode(this.metric);
        result = 31 * result + Objects.hashCode(this.retryFailed);
        result = 31 * result + Objects.hashCode(this.timeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RerouteRequest other = (RerouteRequest)o;
        return Objects.equals(this.clusterManagerTimeout, other.clusterManagerTimeout) && Objects.equals(this.commands, other.commands) && Objects.equals(this.dryRun, other.dryRun) && Objects.equals(this.explain, other.explain) && Objects.equals(this.masterTimeout, other.masterTimeout) && Objects.equals(this.metric, other.metric) && Objects.equals(this.retryFailed, other.retryFailed) && Objects.equals(this.timeout, other.timeout);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RerouteRequest> {
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private List<Command> commands;
        @Nullable
        private Boolean dryRun;
        @Nullable
        private Boolean explain;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private List<ClusterRerouteMetric> metric;
        @Nullable
        private Boolean retryFailed;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(RerouteRequest o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.commands = Builder._listCopy(o.commands);
            this.dryRun = o.dryRun;
            this.explain = o.explain;
            this.masterTimeout = o.masterTimeout;
            this.metric = Builder._listCopy(o.metric);
            this.retryFailed = o.retryFailed;
            this.timeout = o.timeout;
        }

        private Builder(Builder o) {
            super(o);
            this.clusterManagerTimeout = o.clusterManagerTimeout;
            this.commands = Builder._listCopy(o.commands);
            this.dryRun = o.dryRun;
            this.explain = o.explain;
            this.masterTimeout = o.masterTimeout;
            this.metric = Builder._listCopy(o.metric);
            this.retryFailed = o.retryFailed;
            this.timeout = o.timeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder commands(List<Command> list) {
            this.commands = Builder._listAddAll(this.commands, list);
            return this;
        }

        @Nonnull
        public final Builder commands(Command value, Command ... values) {
            this.commands = Builder._listAdd(this.commands, value, values);
            return this;
        }

        @Nonnull
        public final Builder commands(Function<Command.Builder, ObjectBuilder<Command>> fn) {
            return this.commands(fn.apply(new Command.Builder()).build(), new Command[0]);
        }

        @Nonnull
        public final Builder dryRun(@Nullable Boolean value) {
            this.dryRun = value;
            return this;
        }

        @Nonnull
        public final Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        @Nonnull
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder metric(List<ClusterRerouteMetric> list) {
            this.metric = Builder._listAddAll(this.metric, list);
            return this;
        }

        @Nonnull
        public final Builder metric(ClusterRerouteMetric value, ClusterRerouteMetric ... values) {
            this.metric = Builder._listAdd(this.metric, value, values);
            return this;
        }

        @Nonnull
        public final Builder retryFailed(@Nullable Boolean value) {
            this.retryFailed = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public RerouteRequest build() {
            this._checkSingleUse();
            return new RerouteRequest(this);
        }
    }
}

